/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks.hosts;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.epsilon.common.dt.console.EolRuntimeExceptionHyperlinkListener;
import org.eclipse.epsilon.common.dt.extensions.ClassBasedExtension;
import org.eclipse.epsilon.common.dt.launching.EclipseExecutionController;
import org.eclipse.epsilon.common.dt.launching.extensions.ModelTypeExtension;
import org.eclipse.epsilon.ecl.EclModule;
import org.eclipse.epsilon.ecl.dt.launching.EclDebugger;
import org.eclipse.epsilon.egl.EgxModule;
import org.eclipse.epsilon.egl.dt.debug.EgxDebugger;
import org.eclipse.epsilon.eml.EmlModule;
import org.eclipse.epsilon.eml.dt.launching.EmlDebugger;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.dt.ExtensionPointToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.dt.debug.EolDebugTarget;
import org.eclipse.epsilon.eol.dt.debug.EolDebugger;
import org.eclipse.epsilon.eol.dt.userinput.JFaceUserInput;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.IToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.userinput.IUserInput;
import org.eclipse.epsilon.epl.EplModule;
import org.eclipse.epsilon.epl.dt.launching.EplDebugger;
import org.eclipse.epsilon.etl.EtlModule;
import org.eclipse.epsilon.etl.dt.launching.EtlDebugger;
import org.eclipse.epsilon.eunit.EUnitTestListener;
import org.eclipse.epsilon.evl.EvlModule;
import org.eclipse.epsilon.evl.dt.launching.EvlDebugger;
import org.eclipse.epsilon.workflow.tasks.hosts.Host;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IPatternMatchListener;

public class EclipseHost
implements Host {
    @Override
    public boolean isRunning() {
        try {
            Class.forName("org.eclipse.epsilon.eol.dt.ExtensionPointToolNativeTypeDelegate");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void addNativeTypeDelegates(IEolExecutableModule module) {
        module.getContext().getNativeTypeDelegates().add((IToolNativeTypeDelegate)new ExtensionPointToolNativeTypeDelegate());
    }

    @Override
    public void addStopCapabilities(Project project, IEolExecutableModule module) {
        IProgressMonitor monitor = (IProgressMonitor)project.getReferences().get("eclipse.progress.monitor");
        if (monitor != null) {
            module.getContext().getExecutorFactory().setExecutionController((ExecutionController)new EclipseExecutionController(monitor));
        }
    }

    @Override
    public void initialise() {
        if (ConsolePlugin.getDefault() != null) {
            IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            int n = iConsoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole c = iConsoleArray[n2];
                if (c instanceof IOConsole) {
                    IOConsole ioConsole = (IOConsole)c;
                    ioConsole.addPatternMatchListener((IPatternMatchListener)new EolRuntimeExceptionHyperlinkListener(ioConsole));
                }
                ++n2;
            }
        }
    }

    @Override
    public Object debug(IEolExecutableModule module, File file) throws Exception {
        EolDebugger debugger = (EolDebugger)this.createDebugger(module);
        ILaunch currentLaunch = DebugPlugin.getDefault().getLaunchManager().getLaunches()[0];
        currentLaunch.setSourceLocator(null);
        EolDebugTarget target = new EolDebugTarget(currentLaunch, module, debugger, file.getAbsolutePath());
        debugger.setTarget((IDebugTarget)target);
        currentLaunch.addDebugTarget((IDebugTarget)target);
        return target.debug();
    }

    private Object createDebugger(IEolExecutableModule module) {
        if (module instanceof EclModule) {
            return new EclDebugger();
        }
        if (module instanceof EplModule) {
            return new EplDebugger();
        }
        if (module instanceof EmlModule) {
            return new EmlDebugger();
        }
        if (module instanceof EtlModule) {
            return new EtlDebugger();
        }
        if (module instanceof EvlModule) {
            return new EvlDebugger();
        }
        if (module instanceof EgxModule) {
            return new EgxDebugger();
        }
        return new EolDebugger();
    }

    @Override
    public boolean supportsDebugging() {
        return true;
    }

    @Override
    public void configureUserInput(IEolExecutableModule module, boolean isGui) {
        if (isGui) {
            module.getContext().setUserInput((IUserInput)new JFaceUserInput(module.getContext().getPrettyPrinterManager()));
        }
    }

    @Override
    public IModel createModel(String type) throws BuildException {
        try {
            IModel model = ModelTypeExtension.forType((String)type).createModel();
            return model;
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    @Override
    public <T> List<T> getExtensionsOfType(Class<T> klazz) throws Exception {
        String pointID = null;
        if (klazz == EUnitTestListener.class) {
            pointID = "org.eclipse.epsilon.workflow.eunit.listener";
        }
        if (pointID != null) {
            return ClassBasedExtension.getImplementations((String)pointID, klazz);
        }
        return Collections.EMPTY_LIST;
    }
}

