/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransitionKind implements Enumerator
{
    INTERNAL_LITERAL(0, "internal", "internal"),
    LOCAL_LITERAL(1, "local", "local"),
    EXTERNAL_LITERAL(2, "external", "external");

    public static final int INTERNAL = 0;
    public static final int LOCAL = 1;
    public static final int EXTERNAL = 2;
    private static final TransitionKind[] VALUES_ARRAY;
    public static final List<TransitionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TransitionKind[]{INTERNAL_LITERAL, LOCAL_LITERAL, EXTERNAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TransitionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransitionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransitionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransitionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransitionKind get(int value) {
        switch (value) {
            case 0: {
                return INTERNAL_LITERAL;
            }
            case 1: {
                return LOCAL_LITERAL;
            }
            case 2: {
                return EXTERNAL_LITERAL;
            }
        }
        return null;
    }

    private TransitionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

