/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.common.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.common.preferences.PreferenceableOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preference<T>
implements PreferenceableOption.PreferenceableOption2<T> {
    public final String pluginId;
    public final String key;
    public T defaultValue;
    private List<PreferenceableOption.Listener> listeners = null;

    public Preference(@NonNull String pluginId, @NonNull String key, @Nullable T defaultValue) {
        this.pluginId = pluginId;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    public synchronized void addListener(@NonNull PreferenceableOption.Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PreferenceableOption.Listener>();
            OCLCommon.installListener(this);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void fireChanged(String key, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            for (PreferenceableOption.Listener listener : this.listeners) {
                listener.changed(key, oldValue, newValue);
            }
        }
    }

    @Override
    @NonNull
    public String getKey() {
        return this.key;
    }

    @Override
    @NonNull
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Nullable
    public T getPreferredValue() {
        return OCLCommon.getPreference(this, null);
    }

    @Override
    public synchronized void removeListener(@NonNull PreferenceableOption.Listener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void setDefaultValue(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.pluginId)) + " / " + String.valueOf(this.key) + " = " + String.valueOf(this.defaultValue);
    }
}

