/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.graphml;

import org.eclipse.epsilon.emc.graphml.Parser;
import org.eclipse.epsilon.emc.muddle.Feature;
import org.eclipse.epsilon.emc.muddle.MuddleFactory;
import org.eclipse.epsilon.emc.muddle.PrimitiveTypes;

public class ValuedSlotFeatureLabelParser {
    protected Feature feature;
    protected Object value;

    public static void main(String[] args) {
        new ValuedSlotFeatureLabelParser("int[] x = 5").getFeature();
    }

    public ValuedSlotFeatureLabelParser(String label) {
        String featureLabel = "";
        String valueLabel = "";
        int eq = label.indexOf(61);
        if (eq > -1) {
            featureLabel = label.substring(0, eq).trim();
            valueLabel = label.substring(eq + 1, label.length()).trim();
        } else {
            featureLabel = label;
            valueLabel = "";
        }
        Parser typeAndMultiplicityParser = new Parser("(\\S+?)\\s*\\[.*?\\]\\s+(\\S+)");
        Parser typeParser = new Parser("(\\S+?)\\s+(\\S+)");
        String name = "";
        String typeLabel = null;
        boolean many = false;
        if (typeAndMultiplicityParser.matches(featureLabel)) {
            many = true;
            name = typeAndMultiplicityParser.getGroups().get(1);
            typeLabel = typeAndMultiplicityParser.getGroups().get(0);
        } else if (typeParser.matches(featureLabel)) {
            name = typeParser.getGroups().get(1);
            typeLabel = typeParser.getGroups().get(0);
        } else {
            name = featureLabel;
        }
        this.feature = MuddleFactory.eINSTANCE.createFeature();
        this.feature.setName(name);
        this.feature.setMany(many);
        if (typeLabel != null) {
            if (typeLabel.equalsIgnoreCase("Integer") || typeLabel.equals("int")) {
                this.feature.setType(PrimitiveTypes.getIntegerType());
            } else if (typeLabel.equalsIgnoreCase("Boolean") || typeLabel.equals("bool")) {
                this.feature.setType(PrimitiveTypes.getBooleanType());
            } else if (typeLabel.equalsIgnoreCase("Real") || typeLabel.equalsIgnoreCase("real")) {
                this.feature.setType(PrimitiveTypes.getRealType());
            } else {
                this.feature.setType(PrimitiveTypes.getStringType());
            }
        }
        this.value = valueLabel;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Object getValue() {
        return this.value;
    }
}

