/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameStackRegion;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.SingleFrame;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class FrameStack {
    protected FrameStackRegion globals = new FrameStackRegion();
    protected FrameStackRegion locals = new FrameStackRegion();
    protected HashMap<String, Variable> builtInVariables = new HashMap();

    public FrameStack() {
        this.enterGlobal(FrameType.UNPROTECTED, null, new Variable[0]);
        this.builtInVariables.put("null", Variable.createReadOnlyVariable("null", null));
    }

    public void dispose() {
        this.globals.dispose();
        this.locals.dispose();
    }

    public Frame enterGlobal(FrameType type, AST entryPoint, Variable ... variables) {
        return this.globals.enter(type, entryPoint, variables);
    }

    public Frame enterLocal(FrameType type, AST entryPoint, Variable ... variables) {
        return this.locals.enter(type, entryPoint, variables);
    }

    public Frame enter(FrameType type, AST entryPoint, Variable ... variables) {
        return this.enterLocal(type, entryPoint, variables);
    }

    public void leaveLocal(AST entryPoint, boolean dispose) {
        this.locals.leave(entryPoint, dispose);
    }

    public void leaveLocal(AST entryPoint) {
        this.leaveLocal(entryPoint, true);
    }

    public void leaveGlobal(AST entryPoint, boolean dispose) {
        if (this.countGlobalFrames() > 1) {
            this.globals.leave(entryPoint, dispose);
        }
    }

    public void leaveGlobal(AST entryPoint) {
        this.leaveGlobal(entryPoint, true);
    }

    public void leave(AST entryPoint, boolean dispose) {
        this.leaveLocal(entryPoint, dispose);
    }

    public void leave(AST entryPoint) {
        this.leaveLocal(entryPoint, true);
    }

    public void put(Variable ... variables) {
        this.activeGroup().put(variables);
    }

    public void put(Variable variable) {
        this.activeGroup().put(variable);
    }

    public void putGlobal(Variable ... variables) {
        this.globals.put(variables);
    }

    public void putGlobal(Variable variable) {
        this.globals.put(variable);
    }

    public void remove(String variable) {
        this.activeGroup().top().remove(variable);
    }

    public Variable get(String name) {
        if (this.builtInVariables.containsKey(name)) {
            return this.builtInVariables.get(name);
        }
        Variable var = this.locals.get(name);
        if (var == null) {
            var = this.globals.get(name);
        }
        return var;
    }

    public Variable getLocal(String name) {
        return this.locals.get(name);
    }

    public Variable getGlobal(String name) {
        return this.globals.get(name);
    }

    public boolean isInLoop() {
        return this.locals.isInLoop() || this.globals.isInLoop();
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    public boolean containsLocal(String name) {
        return this.locals.get(name) != null;
    }

    public boolean containsGlobal(String name) {
        return this.globals.get(name) != null;
    }

    @Deprecated
    public Frame getGlobals() {
        return new GlobalFrame();
    }

    public List<SingleFrame> getFrames() {
        ArrayList<SingleFrame> frames = new ArrayList<SingleFrame>();
        frames.addAll(this.locals.getFrames());
        frames.addAll(this.globals.getFrames());
        return frames;
    }

    public int getDepth() {
        return this.locals.frameCount() + this.globals.frameCount();
    }

    public FrameStack clone() {
        FrameStack clone = new FrameStack();
        clone.locals = this.locals.clone();
        clone.globals = this.globals.clone();
        return clone;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-----------SCOPE------------\r\n");
        buffer.append(this.locals.toString());
        buffer.append("----------GLOBALS-----------\r\n");
        buffer.append(this.globals.toString());
        return buffer.toString();
    }

    public AST getCurrentStatement() {
        return this.activeGroup().top().getCurrentStatement();
    }

    public void setCurrentStatement(AST ast) {
        this.activeGroup().top().setCurrentStatement(ast);
    }

    protected int countGlobalFrames() {
        return this.globals.frameCount();
    }

    private FrameStackRegion activeGroup() {
        return this.locals.isEmpty() ? this.globals : this.locals;
    }

    private class GlobalFrame
    implements Frame {
        private GlobalFrame() {
        }

        @Override
        public void dispose() {
            FrameStack.this.globals.dispose();
        }

        @Override
        public void clear() {
            FrameStack.this.globals.clear();
        }

        @Override
        public String getLabel() {
            return FrameStack.this.globals.top().getLabel();
        }

        @Override
        public void setLabel(String label) {
            FrameStack.this.globals.top().setLabel(label);
        }

        @Override
        public void put(String name, Object value) {
            FrameStack.this.globals.put(name, value);
        }

        @Override
        public void remove(String name) {
            FrameStack.this.globals.remove(name);
        }

        @Override
        public void put(Variable variable) {
            FrameStack.this.globals.put(variable);
        }

        @Override
        public void putAll(Map<String, Variable> variables) {
            FrameStack.this.globals.putAll(variables);
        }

        @Override
        public Variable get(String name) {
            return FrameStack.this.globals.get(name);
        }

        @Override
        public Map<String, Variable> getAll() {
            return FrameStack.this.globals.getAll();
        }

        @Override
        public boolean contains(String key) {
            return this.get(key) != null;
        }

        @Override
        public FrameType getType() {
            return FrameStack.this.globals.top().getType();
        }

        @Override
        public void setType(FrameType type) {
            FrameStack.this.globals.top().setType(type);
        }

        @Override
        public AST getEntryPoint() {
            return FrameStack.this.globals.top().getEntryPoint();
        }

        @Override
        public void setEntryPoint(AST entryPoint) {
            FrameStack.this.globals.top().setEntryPoint(entryPoint);
        }

        @Override
        public AST getCurrentStatement() {
            return FrameStack.this.globals.top().getCurrentStatement();
        }

        @Override
        public void setCurrentStatement(AST ast) {
            FrameStack.this.globals.top().setCurrentStatement(ast);
        }
    }
}

