/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.flock.FlockContext;
import org.eclipse.epsilon.flock.FlockResult;
import org.eclipse.epsilon.flock.IFlockContext;
import org.eclipse.epsilon.flock.IFlockModule;
import org.eclipse.epsilon.flock.model.domain.MigrationStrategy;
import org.eclipse.epsilon.flock.model.loader.MigrationStrategyLoader;
import org.eclipse.epsilon.flock.parse.FlockLexer;
import org.eclipse.epsilon.flock.parse.FlockParser;

public class FlockModule
extends ErlModule
implements IFlockModule {
    private MigrationStrategy strategy;
    protected IFlockContext context = new FlockContext();

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new FlockLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new FlockParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "flockModule";
    }

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        this.strategy = new MigrationStrategyLoader(this.ast).run();
    }

    @Override
    public FlockResult execute(IModel original, IModel migrated) throws EolRuntimeException {
        this.context.setOriginalModel(original);
        this.context.setMigratedModel(migrated);
        return this.execute();
    }

    @Override
    public FlockResult execute() throws EolRuntimeException {
        FlockResult result = null;
        this.prepareContext(this.context);
        this.execute(this.getPre(), this.context);
        result = this.context.execute(this.strategy);
        this.execute(this.getPost(), this.context);
        return result;
    }

    @Override
    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.getImports());
        children.addAll(this.getDeclaredPre());
        children.addAll(this.strategy.getTypeMappingsAndRules());
        children.addAll(this.getDeclaredOperations());
        children.addAll(this.getDeclaredPost());
        return children;
    }

    @Override
    public IFlockContext getContext() {
        return this.context;
    }

    @Override
    protected int getPreBlockTokenType() {
        return 76;
    }

    @Override
    protected int getPostBlockTokenType() {
        return 77;
    }

    @Override
    public void setContext(IEolContext context) {
        if (context instanceof IFlockContext) {
            this.context = (IFlockContext)context;
        }
    }
}

