/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock;

import org.eclipse.epsilon.flock.IFlockContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.equivalences.Equivalences;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.MigrationStrategy;

public class MigrationStrategyRunner {
    private final IFlockContext context;
    private final MigrationStrategy strategy;
    private Equivalences equivalences;

    public MigrationStrategyRunner(IFlockContext context, MigrationStrategy strategy) {
        this.context = context;
        this.strategy = strategy;
    }

    public void run() throws FlockRuntimeException {
        this.checkStrategyAgainstModels();
        this.establishEquivalences();
        this.conservativeCopy();
        this.applyRules();
    }

    private void checkStrategyAgainstModels() {
        this.strategy.checkTypeMappingsAndRules(this.context.getMigrationStrategyCheckingContext());
    }

    private void establishEquivalences() throws FlockRuntimeException {
        this.equivalences = Equivalences.establishFrom(this.strategy, this.context.getEquivalenceEstablishmentContext());
    }

    private void conservativeCopy() throws FlockRuntimeException {
        this.equivalences.conservativeCopy(this.strategy, this.context.getConservativeCopyContext());
    }

    private void applyRules() throws FlockRuntimeException {
        this.equivalences.applyRules(this.strategy);
    }

    public ModelElement getEquivalent(ModelElement originalModelElement) {
        return this.equivalences.getEquivalent(originalModelElement);
    }
}

