/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.operations.contributors.StringOperationContributor;
import org.eclipse.epsilon.eol.models.Model;
import org.eclipse.epsilon.epl.Pattern;
import org.eclipse.epsilon.epl.PatternMatch;
import org.eclipse.epsilon.epl.PatternMatchPropertyGetter;
import org.eclipse.epsilon.epl.PatternMatchPropertySetter;
import org.eclipse.epsilon.epl.Role;

public class PatternMatchModel
extends Model {
    protected HashMap<String, List<PatternMatch>> matchMap = new HashMap();
    protected HashSet<PatternMatch> matches = new HashSet();
    protected PatternMatchPropertyGetter propertyGetter;
    protected PatternMatchPropertySetter propertySetter = new PatternMatchPropertySetter();
    protected HashMap<String, HashSet<Object>> componentMap = new HashMap();

    @Override
    public void dispose() {
        super.dispose();
        this.matches.clear();
        for (String key : this.componentMap.keySet()) {
            this.componentMap.get(key).clear();
        }
        this.componentMap.clear();
    }

    public void addMatch(PatternMatch match) {
        String patternName = match.getPattern().getName();
        List<PatternMatch> matchMapMatches = this.matchMap.get(patternName);
        matchMapMatches.add(match);
        this.matchMap.put(patternName, matchMapMatches);
        this.matches.add(match);
        StringOperationContributor stringOps = new StringOperationContributor();
        for (String componentName : match.getRoleBindings().keySet()) {
            stringOps.setTarget(componentName);
            HashSet<Object> values = this.componentMap.get(String.valueOf(patternName) + stringOps.firstToUpperCase());
            if (values == null) continue;
            values.add(match.getRoleBindings().get(componentName));
        }
    }

    protected HashMap<String, HashSet<Object>> getComponentMap() {
        return this.componentMap;
    }

    public void setPatterns(List<Pattern> patterns) {
        StringOperationContributor stringOps = new StringOperationContributor();
        for (Pattern pattern : patterns) {
            this.matchMap.put(pattern.getName(), new ArrayList());
            for (Role role : pattern.getRoles()) {
                if (role.isNegative()) continue;
                for (String name : role.getNames()) {
                    stringOps.setTarget(name);
                    String componentName = String.valueOf(pattern.getName()) + stringOps.firstToUpperCase();
                    this.componentMap.put(componentName, new HashSet());
                }
            }
        }
    }

    @Override
    public void load() throws EolModelLoadingException {
    }

    @Override
    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        return null;
    }

    @Override
    public Collection<?> allContents() {
        return this.getMatches();
    }

    public HashSet<PatternMatch> getMatches() {
        return this.matches;
    }

    @Override
    public Collection<?> getAllOfType(String type) throws EolModelElementTypeNotFoundException {
        if (this.matchMap.containsKey(type)) {
            return this.matchMap.get(type);
        }
        return this.componentMap.get(type);
    }

    @Override
    public Collection<?> getAllOfKind(String type) throws EolModelElementTypeNotFoundException {
        return this.getAllOfType(type);
    }

    @Override
    public Object getTypeOf(Object instance) {
        return PatternMatch.class;
    }

    @Override
    public String getTypeNameOf(Object instance) {
        if (instance instanceof PatternMatch) {
            return ((PatternMatch)instance).getPattern().getName();
        }
        return null;
    }

    @Override
    public Object createInstance(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        throw new EolNotInstantiableModelElementTypeException(this.name, type);
    }

    @Override
    public Object getElementById(String id) {
        return null;
    }

    @Override
    public String getElementId(Object instance) {
        return null;
    }

    @Override
    public void setElementId(Object instance, String newId) {
    }

    @Override
    public void deleteElement(Object instance) throws EolRuntimeException {
    }

    @Override
    public boolean owns(Object instance) {
        return this.matches.contains(instance);
    }

    @Override
    public boolean isInstantiable(String type) {
        return false;
    }

    @Override
    public boolean isModelElement(Object instance) {
        return this.owns(instance);
    }

    @Override
    public boolean hasType(String type) {
        return this.matchMap.containsKey(type) || this.componentMap.containsKey(type);
    }

    @Override
    public boolean store(String location) {
        return false;
    }

    @Override
    public boolean store() {
        return false;
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        if (this.propertyGetter == null) {
            this.propertyGetter = new PatternMatchPropertyGetter();
        }
        return this.propertyGetter;
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return this.propertySetter;
    }
}

