/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import org.w3c.dom.Element;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.pmml.FieldMetaInfo;

public class MiningFieldMetaInfo
extends FieldMetaInfo
implements Serializable {
    private static final long serialVersionUID = -1256774332779563185L;
    Usage m_usageType = Usage.ACTIVE;
    protected Outlier m_outlierTreatmentMethod = Outlier.ASIS;
    protected double m_lowValue;
    protected double m_highValue;
    protected Missing m_missingValueTreatmentMethod = Missing.ASIS;
    protected String m_missingValueReplacementNominal;
    protected double m_missingValueReplacementNumeric;
    protected FieldMetaInfo.Optype m_optypeOverride = FieldMetaInfo.Optype.NONE;
    protected int m_index;
    protected double m_importance;
    Instances m_miningSchemaI = null;

    protected void setMiningSchemaInstances(Instances miningSchemaI) {
        this.m_miningSchemaI = miningSchemaI;
    }

    public Usage getUsageType() {
        return this.m_usageType;
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        temp.append(this.m_miningSchemaI.attribute(this.m_index));
        temp.append("\n\tusage: " + (Object)((Object)this.m_usageType) + "\n\toutlier treatment: " + (Object)((Object)this.m_outlierTreatmentMethod));
        if (this.m_outlierTreatmentMethod == Outlier.ASEXTREMEVALUES) {
            temp.append(" (lowValue = " + this.m_lowValue + " highValue = " + this.m_highValue + ")");
        }
        temp.append("\n\tmissing value treatment: " + (Object)((Object)this.m_missingValueTreatmentMethod));
        if (this.m_missingValueTreatmentMethod != Missing.ASIS) {
            temp.append(" (replacementValue = " + (this.m_missingValueReplacementNominal != null ? this.m_missingValueReplacementNominal : Utils.doubleToString(this.m_missingValueReplacementNumeric, 4)) + ")");
        }
        return temp.toString();
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public String getName() {
        return this.m_fieldName;
    }

    public Outlier getOutlierTreatmentMethod() {
        return this.m_outlierTreatmentMethod;
    }

    public Missing getMissingValueTreatmentMethod() {
        return this.m_missingValueTreatmentMethod;
    }

    public double applyMissingValueTreatment(double value) throws Exception {
        double newVal = value;
        if (this.m_missingValueTreatmentMethod != Missing.ASIS && Utils.isMissingValue(value)) {
            if (this.m_missingValueReplacementNominal != null) {
                Attribute att = this.m_miningSchemaI.attribute(this.m_index);
                int valIndex = att.indexOfValue(this.m_missingValueReplacementNominal);
                if (valIndex < 0) {
                    throw new Exception("[MiningSchema] Nominal missing value replacement value doesn't exist in the mining schema Instances!");
                }
                newVal = valIndex;
            } else {
                newVal = this.m_missingValueReplacementNumeric;
            }
        }
        return newVal;
    }

    public double applyOutlierTreatment(double value) throws Exception {
        double newVal = value;
        if (this.m_outlierTreatmentMethod != Outlier.ASIS) {
            if (this.m_outlierTreatmentMethod == Outlier.ASMISSINGVALUES) {
                newVal = this.applyMissingValueTreatment(value);
            } else if (value < this.m_lowValue) {
                newVal = this.m_lowValue;
            } else if (value > this.m_highValue) {
                newVal = this.m_highValue;
            }
        }
        return newVal;
    }

    @Override
    public Attribute getFieldAsAttribute() {
        return this.m_miningSchemaI.attribute(this.m_index);
    }

    public MiningFieldMetaInfo(Element field) throws Exception {
        super(field);
        String missingReplacement;
        String usage = field.getAttribute("usageType");
        Usage[] usageArray = Usage.values();
        int n = usageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Usage u = usageArray[n2];
            if (u.toString().equals(usage)) {
                this.m_usageType = u;
                break;
            }
            ++n2;
        }
        String importance = field.getAttribute("importance");
        if (importance.length() > 0) {
            this.m_importance = Double.parseDouble(importance);
        }
        String outliers = field.getAttribute("outliers");
        Outlier[] outlierArray = Outlier.values();
        int n3 = outlierArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Outlier o = outlierArray[n4];
            if (o.toString().equals(outliers)) {
                this.m_outlierTreatmentMethod = o;
                break;
            }
            ++n4;
        }
        if (outliers.length() > 0 && this.m_outlierTreatmentMethod == Outlier.ASEXTREMEVALUES) {
            String lowValue = field.getAttribute("lowValue");
            if (lowValue.length() <= 0) {
                throw new Exception("[MiningFieldMetaInfo] as extreme values outlier treatment specified, but no low value defined!");
            }
            this.m_lowValue = Double.parseDouble(lowValue);
            String highValue = field.getAttribute("highValue");
            if (highValue.length() > 0) {
                this.m_highValue = Double.parseDouble(highValue);
            } else {
                throw new Exception("[MiningFieldMetaInfo] as extreme values outlier treatment specified, but no high value defined!");
            }
        }
        if ((missingReplacement = field.getAttribute("missingValueReplacement")).length() > 0) {
            try {
                this.m_missingValueReplacementNumeric = Double.parseDouble(missingReplacement);
            }
            catch (IllegalArgumentException ex) {
                this.m_missingValueReplacementNominal = missingReplacement;
            }
            String missingTreatment = field.getAttribute("missingValueTreatment");
            Missing[] missingArray = Missing.values();
            int n5 = missingArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Missing m = missingArray[n6];
                if (m.toString().equals(missingTreatment)) {
                    this.m_missingValueTreatmentMethod = m;
                    break;
                }
                ++n6;
            }
        }
    }

    static enum Missing {
        ASIS("asIs"),
        ASMEAN("asMean"),
        ASMODE("asMode"),
        ASMEDIAN("asMedian"),
        ASVALUE("asValue");

        private final String m_stringVal;

        private Missing(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    static enum Outlier {
        ASIS("asIs"),
        ASMISSINGVALUES("asMissingValues"),
        ASEXTREMEVALUES("asExtremeValues");

        private final String m_stringVal;

        private Outlier(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    static enum Usage {
        ACTIVE("active"),
        PREDICTED("predicted"),
        SUPPLEMENTARY("supplementary"),
        GROUP("group"),
        ORDER("order");

        private final String m_stringVal;

        private Usage(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

