/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public class ReflectionUtil {
    public static Object invokeMethodSafe(Object source, String method, Collection<Object> arguments) {
        try {
            return ReflectionUtil.invokeMethod(source, method, arguments);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invokeMethod(Object source, String method, Collection<Object> arguments) throws Exception {
        ArrayList argumentClasses = new ArrayList();
        for (Object argument : arguments) {
            argumentClasses.add(argument.getClass());
        }
        if (source == null) {
            return null;
        }
        Method[] methodArray = source.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equalsIgnoreCase(method)) {
                m.setAccessible(true);
                return m.invoke(source, arguments.toArray());
            }
            ++n2;
        }
        return null;
    }

    public static Object getFieldValue(Object source, String field) throws Exception {
        Field[] fieldArray = source.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            f.setAccessible(true);
            if (f.getName().equalsIgnoreCase(field)) {
                return f.get(source);
            }
            ++n2;
        }
        return null;
    }
}

