/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.spec;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.epsilon.egl.execute.control.ITemplateExecutionListener;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.incremental.IncrementalitySettings;
import org.eclipse.epsilon.egl.internal.IEglModule;
import org.eclipse.epsilon.egl.traceability.Template;

public abstract class EglTemplateSpecification {
    private final String name;
    private final Formatter defaultFormatter;
    private final IncrementalitySettings incrementalitySettings;
    private final Collection<ITemplateExecutionListener> listeners;

    protected EglTemplateSpecification(String name, Formatter defaultFormatter, IncrementalitySettings incrementalitySettings, Collection<ITemplateExecutionListener> listeners) {
        this.name = name;
        this.defaultFormatter = defaultFormatter;
        this.incrementalitySettings = incrementalitySettings;
        this.listeners = listeners;
    }

    public String getName() {
        return this.name;
    }

    public Formatter getDefaultFormatter() {
        return this.defaultFormatter;
    }

    public IncrementalitySettings getIncrementalitySettings() {
        return new IncrementalitySettings(this.incrementalitySettings);
    }

    public Collection<ITemplateExecutionListener> getTemplateExecutionListeners() {
        return new LinkedList<ITemplateExecutionListener>(this.listeners);
    }

    public abstract Template createTemplate();

    public abstract void parseInto(IEglModule var1) throws Exception;

    public abstract URI getURI();
}

