/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.validation;

import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.evl.EvlUnsatisfiedConstraint;
import org.eclipse.epsilon.evl.IEvlFixer;
import org.eclipse.epsilon.evl.IEvlModule;

public abstract class AbstractFixer
implements IEvlFixer {
    private IEvlModule module = null;
    private boolean changedModel = false;

    @Override
    public void fix(IEvlModule module) throws EolRuntimeException {
        this.module = module;
        this.applyFixes();
    }

    private void applyFixes() throws EolRuntimeException {
        this.reset();
        for (EvlUnsatisfiedConstraint constraint : this.module.getContext().getUnsatisfiedConstraints()) {
            if (constraint.getFixes().isEmpty()) continue;
            this.changedModel = this.applyFix(constraint);
        }
    }

    public void reset() {
        this.changedModel = false;
    }

    public boolean hasChangedModel() {
        return this.changedModel;
    }

    protected boolean applyFix(EvlUnsatisfiedConstraint constraint) throws EolRuntimeException {
        return false;
    }

    protected abstract ParseProblem interpretUnsatisfiedConstraint(EvlUnsatisfiedConstraint var1);
}

