/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UMLPlugin
extends EMFPlugin {
    private static Map<String, URI> ePackageNsURIToProfileLocationMap;
    protected static final String GENERATED_PACKAGE_PPID = "generated_package";
    protected static final String DYNAMIC_PACKAGE_PPID = "dynamic_package";
    public static final UMLPlugin INSTANCE;
    private static Implementation plugin;

    static {
        INSTANCE = new UMLPlugin();
    }

    public static Map<String, URI> getEPackageNsURIToProfileLocationMap() {
        if (ePackageNsURIToProfileLocationMap == null) {
            ePackageNsURIToProfileLocationMap = new HashMap<String, URI>();
        }
        return ePackageNsURIToProfileLocationMap;
    }

    public UMLPlugin() {
        super(new ResourceLocator[0]);
    }

    @Override
    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DynamicPackageRegistryReader
    extends PackageRegistryReader {
        protected DynamicPackageRegistryReader() {
            super(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), UMLPlugin.DYNAMIC_PACKAGE_PPID);
        }

        protected DynamicPackageRegistryReader(Map<String, URI> ePackageNsURIToProfileLocationMap) {
            super(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), UMLPlugin.DYNAMIC_PACKAGE_PPID, ePackageNsURIToProfileLocationMap);
        }
    }

    public static class ExtensionProcessor {
        public static synchronized void process(ClassLoader classLoader) {
            EcorePlugin.ExtensionProcessor.process(classLoader);
            if (ePackageNsURIToProfileLocationMap == null && !EMFPlugin.IS_ECLIPSE_RUNNING) {
                ePackageNsURIToProfileLocationMap = new HashMap();
                ExtensionProcessor.internalProcessExtensions();
                ExtensionProcessor.mapPlatformPluginURIs();
            }
        }

        private static void internalProcessExtensions() {
            new GeneratedPackageRegistryReader(UMLPlugin.getEPackageNsURIToProfileLocationMap()).readRegistry();
            new DynamicPackageRegistryReader(UMLPlugin.getEPackageNsURIToProfileLocationMap()).readRegistry();
        }

        private static void mapPlatformPluginURIs() {
            HashSet<URI> umlResourceURIs = new HashSet<URI>();
            umlResourceURIs.add(URIConverter.INSTANCE.normalize(URI.createURI("pathmap://UML_LIBRARIES/")));
            URIConverter.URI_MAP.putAll(EcorePlugin.computePlatformResourceToPlatformPluginMap(umlResourceURIs));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GeneratedPackageRegistryReader
    extends PackageRegistryReader {
        protected GeneratedPackageRegistryReader() {
            super(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), UMLPlugin.GENERATED_PACKAGE_PPID);
        }

        protected GeneratedPackageRegistryReader(Map<String, URI> ePackageNsURIToProfileLocationMap) {
            super(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), UMLPlugin.GENERATED_PACKAGE_PPID, ePackageNsURIToProfileLocationMap);
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            ExtensionProcessor.internalProcessExtensions();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PackageRegistryReader
    extends RegistryReader {
        protected static final String TAG_PROFILE = "profile";
        protected static final String ATT_URI = "uri";
        protected static final String ATT_LOCATION = "location";
        protected Map<String, URI> ePackageNsURIToProfileLocationMap;

        protected PackageRegistryReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID) {
            super(pluginRegistry, pluginID, extensionPointID);
        }

        protected PackageRegistryReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID, Map<String, URI> ePackageNsURIToProfileLocationMap) {
            this(pluginRegistry, pluginID, extensionPointID);
            this.ePackageNsURIToProfileLocationMap = ePackageNsURIToProfileLocationMap;
        }

        @Override
        protected boolean readElement(IConfigurationElement element, boolean add) {
            if (element.getName().equals(TAG_PROFILE)) {
                String uri = element.getAttribute(ATT_URI);
                if (uri == null) {
                    this.logMissingAttribute(element, ATT_URI);
                } else {
                    if (add) {
                        String location;
                        if (this.ePackageNsURIToProfileLocationMap != null && (location = element.getAttribute(ATT_LOCATION)) != null) {
                            URI profileLocation = URI.createURI(location);
                            if (profileLocation.isRelative()) {
                                profileLocation = URI.createPlatformPluginURI(String.valueOf(element.getDeclaringExtension().getContributor().getName()) + '/' + location, false);
                            }
                            this.ePackageNsURIToProfileLocationMap.put(uri, profileLocation);
                        }
                        return true;
                    }
                    this.ePackageNsURIToProfileLocationMap.remove(uri);
                    return true;
                }
            }
            return false;
        }
    }
}

