/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class CheckBoxList
extends JList {
    private static final long serialVersionUID = -4359573373359270258L;

    public CheckBoxList() {
        this((CheckBoxListModel)null);
    }

    public CheckBoxList(CheckBoxListModel model) {
        if (model == null) {
            model = new CheckBoxListModel();
        }
        this.setModel((ListModel)model);
        this.setCellRenderer(new CheckBoxListRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    CheckBoxList.this.setChecked(index, !CheckBoxList.this.getChecked(index));
                    CheckBoxList.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ' && e.getModifiers() == 0) {
                    int index;
                    CheckBoxList.this.setChecked(index, !CheckBoxList.this.getChecked(index = CheckBoxList.this.getSelectedIndex()));
                    e.consume();
                    CheckBoxList.this.repaint();
                }
            }
        });
    }

    public void setModel(ListModel model) {
        if (!(model instanceof CheckBoxListModel)) {
            throw new IllegalArgumentException("Model must be an instance of CheckBoxListModel!");
        }
        super.setModel(model);
    }

    public void setListData(Object[] listData) {
        this.setModel((ListModel)new CheckBoxListModel(listData));
    }

    public void setListData(Vector listData) {
        this.setModel((ListModel)new CheckBoxListModel(listData));
    }

    public boolean getChecked(int index) {
        return ((CheckBoxListModel)this.getModel()).getChecked(index);
    }

    public void setChecked(int index, boolean checked) {
        ((CheckBoxListModel)this.getModel()).setChecked(index, checked);
    }

    public int[] getCheckedIndices() {
        Vector<Integer> list = new Vector<Integer>();
        int i = 0;
        while (i < this.getModel().getSize()) {
            if (this.getChecked(i)) {
                list.add(new Integer(i));
            }
            ++i;
        }
        int[] result = new int[list.size()];
        i = 0;
        while (i < list.size()) {
            result[i] = (Integer)list.get(i);
            ++i;
        }
        return result;
    }

    protected class CheckBoxListItem {
        private boolean m_Checked = false;
        private Object m_Content = null;

        public CheckBoxListItem(Object o) {
            this(o, false);
        }

        public CheckBoxListItem(Object o, boolean checked) {
            this.m_Checked = checked;
            this.m_Content = o;
        }

        public Object getContent() {
            return this.m_Content;
        }

        public void setChecked(boolean value) {
            this.m_Checked = value;
        }

        public boolean getChecked() {
            return this.m_Checked;
        }

        public String toString() {
            return this.m_Content.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CheckBoxListItem)) {
                throw new IllegalArgumentException("Must be a CheckBoxListItem!");
            }
            return this.getContent().equals(((CheckBoxListItem)o).getContent());
        }
    }

    public class CheckBoxListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 7772455499540273507L;

        public CheckBoxListModel() {
        }

        public CheckBoxListModel(Object[] listData) {
            Object[] objectArray = listData;
            int n = listData.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.addElement(element);
                ++n2;
            }
        }

        public CheckBoxListModel(Vector listData) {
            int i = 0;
            while (i < listData.size()) {
                this.addElement(listData.get(i));
                ++i;
            }
        }

        public void add(int index, Object element) {
            if (!(element instanceof CheckBoxListItem)) {
                super.add(index, new CheckBoxListItem(element));
            } else {
                super.add(index, element);
            }
        }

        public void addElement(Object obj) {
            if (!(obj instanceof CheckBoxListItem)) {
                super.addElement(new CheckBoxListItem(obj));
            } else {
                super.addElement(obj);
            }
        }

        @Override
        public boolean contains(Object elem) {
            if (!(elem instanceof CheckBoxListItem)) {
                return super.contains(new CheckBoxListItem(elem));
            }
            return super.contains(elem);
        }

        @Override
        public void copyInto(Object[] anArray) {
            if (anArray.length < this.getSize()) {
                throw new IndexOutOfBoundsException("Array not big enough!");
            }
            int i = 0;
            while (i < this.getSize()) {
                anArray[i] = ((CheckBoxListItem)this.getElementAt(i)).getContent();
                ++i;
            }
        }

        public Object elementAt(int index) {
            return ((CheckBoxListItem)super.elementAt(index)).getContent();
        }

        public Object firstElement() {
            return ((CheckBoxListItem)super.firstElement()).getContent();
        }

        public Object get(int index) {
            return ((CheckBoxListItem)super.get(index)).getContent();
        }

        @Override
        public Object getElementAt(int index) {
            return ((CheckBoxListItem)super.getElementAt(index)).getContent();
        }

        @Override
        public int indexOf(Object elem) {
            if (!(elem instanceof CheckBoxListItem)) {
                return super.indexOf(new CheckBoxListItem(elem));
            }
            return super.indexOf(elem);
        }

        @Override
        public int indexOf(Object elem, int index) {
            if (!(elem instanceof CheckBoxListItem)) {
                return super.indexOf(new CheckBoxListItem(elem), index);
            }
            return super.indexOf(elem, index);
        }

        public void insertElementAt(Object obj, int index) {
            if (!(obj instanceof CheckBoxListItem)) {
                super.insertElementAt(new CheckBoxListItem(obj), index);
            } else {
                super.insertElementAt(obj, index);
            }
        }

        public Object lastElement() {
            return ((CheckBoxListItem)super.lastElement()).getContent();
        }

        @Override
        public int lastIndexOf(Object elem) {
            if (!(elem instanceof CheckBoxListItem)) {
                return super.lastIndexOf(new CheckBoxListItem(elem));
            }
            return super.lastIndexOf(elem);
        }

        @Override
        public int lastIndexOf(Object elem, int index) {
            if (!(elem instanceof CheckBoxListItem)) {
                return super.lastIndexOf(new CheckBoxListItem(elem), index);
            }
            return super.lastIndexOf(elem, index);
        }

        public Object remove(int index) {
            return ((CheckBoxListItem)super.remove(index)).getContent();
        }

        @Override
        public boolean removeElement(Object obj) {
            if (!(obj instanceof CheckBoxListItem)) {
                return super.removeElement(new CheckBoxListItem(obj));
            }
            return super.removeElement(obj);
        }

        public Object set(int index, Object element) {
            if (!(element instanceof CheckBoxListItem)) {
                return super.set(index, new CheckBoxListItem(element)).getContent();
            }
            return ((CheckBoxListItem)super.set(index, element)).getContent();
        }

        public void setElementAt(Object obj, int index) {
            if (!(obj instanceof CheckBoxListItem)) {
                super.setElementAt(new CheckBoxListItem(obj), index);
            } else {
                super.setElementAt(obj, index);
            }
        }

        @Override
        public Object[] toArray() {
            Object[] internal = super.toArray();
            Object[] result = new Object[internal.length];
            int i = 0;
            while (i < internal.length) {
                result[i] = ((CheckBoxListItem)internal[i]).getContent();
                ++i;
            }
            return result;
        }

        public boolean getChecked(int index) {
            return ((CheckBoxListItem)super.getElementAt(index)).getChecked();
        }

        public void setChecked(int index, boolean checked) {
            ((CheckBoxListItem)super.getElementAt(index)).setChecked(checked);
        }
    }

    public class CheckBoxListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = 1059591605858524586L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setSelected(((CheckBoxList)list).getChecked(index));
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setFocusPainted(false);
            return this;
        }
    }
}

