/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.gui.GenericArrayEditor;
import weka.gui.PropertySelectorDialog;

public class GeneratorPropertyIteratorPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -6026938995241632139L;
    protected JButton m_ConfigureBut = new JButton("Select property...");
    protected JComboBox m_StatusBox = new JComboBox();
    protected GenericArrayEditor m_ArrayEditor = new GenericArrayEditor();
    protected Experiment m_Exp;
    protected ArrayList<ActionListener> m_Listeners = new ArrayList();

    public GeneratorPropertyIteratorPanel() {
        String[] options = new String[]{"Disabled", "Enabled"};
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>(options);
        this.m_StatusBox.setModel(cbm);
        this.m_StatusBox.setSelectedIndex(0);
        this.m_StatusBox.addActionListener(this);
        this.m_StatusBox.setEnabled(false);
        this.m_ConfigureBut.setEnabled(false);
        this.m_ConfigureBut.addActionListener(this);
        JPanel buttons = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttons.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        buttons.add((Component)this.m_StatusBox, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        buttons.add((Component)this.m_ConfigureBut, constraints);
        buttons.setMaximumSize(new Dimension(buttons.getMaximumSize().width, buttons.getMinimumSize().height));
        this.setBorder(BorderFactory.createTitledBorder("Generator properties"));
        this.setLayout(new BorderLayout());
        this.add((Component)buttons, "North");
        ((JComponent)this.m_ArrayEditor.getCustomEditor()).setBorder(BorderFactory.createEtchedBorder());
        this.m_ArrayEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                System.err.println("Updating experiment property iterator array");
                GeneratorPropertyIteratorPanel.this.m_Exp.setPropertyArray(GeneratorPropertyIteratorPanel.this.m_ArrayEditor.getValue());
            }
        });
        this.add(this.m_ArrayEditor.getCustomEditor(), "Center");
    }

    public GeneratorPropertyIteratorPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public boolean getEditorActive() {
        return this.m_StatusBox.getSelectedIndex() != 0;
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_StatusBox.setEnabled(true);
        this.m_ArrayEditor.setValue(this.m_Exp.getPropertyArray());
        if (this.m_Exp.getPropertyArray() == null) {
            this.m_StatusBox.setSelectedIndex(0);
            this.m_ConfigureBut.setEnabled(false);
        } else {
            this.m_StatusBox.setSelectedIndex(this.m_Exp.getUsePropertyIterator() ? 1 : 0);
            this.m_ConfigureBut.setEnabled(this.m_Exp.getUsePropertyIterator());
        }
        this.validate();
    }

    protected int selectProperty() {
        PropertySelectorDialog jd = new PropertySelectorDialog(null, this.m_Exp.getResultProducer());
        jd.setLocationRelativeTo(this);
        int result = jd.showDialog();
        if (result == 0) {
            System.err.println("Property Selected");
            PropertyNode[] path = jd.getPath();
            Object value = path[path.length - 1].value;
            PropertyDescriptor property = path[path.length - 1].property;
            Class<?> propertyClass = property.getPropertyType();
            this.m_Exp.setPropertyPath(path);
            this.m_Exp.setPropertyArray(Array.newInstance(propertyClass, 1));
            Array.set(this.m_Exp.getPropertyArray(), 0, value);
            this.m_ArrayEditor.setValue(this.m_Exp.getPropertyArray());
            this.m_ArrayEditor.getCustomEditor().repaint();
            System.err.println("Set new array to array editor");
        } else {
            System.err.println("Cancelled");
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_ConfigureBut) {
            this.selectProperty();
        } else if (e.getSource() == this.m_StatusBox) {
            int i = 0;
            while (i < this.m_Listeners.size()) {
                ActionListener temp = this.m_Listeners.get(i);
                temp.actionPerformed(new ActionEvent(this, 1001, "Editor status change"));
                ++i;
            }
            if (this.m_StatusBox.getSelectedIndex() == 0) {
                this.m_Exp.setUsePropertyIterator(false);
                this.m_ConfigureBut.setEnabled(false);
                this.m_ArrayEditor.getCustomEditor().setEnabled(false);
                this.m_ArrayEditor.setValue(null);
                this.validate();
            } else {
                if (this.m_Exp.getPropertyArray() == null) {
                    this.selectProperty();
                }
                if (this.m_Exp.getPropertyArray() == null) {
                    this.m_StatusBox.setSelectedIndex(0);
                } else {
                    this.m_Exp.setUsePropertyIterator(true);
                    this.m_ConfigureBut.setEnabled(true);
                    this.m_ArrayEditor.getCustomEditor().setEnabled(true);
                }
                this.validate();
            }
        }
    }

    public void addActionListener(ActionListener newA) {
        this.m_Listeners.add(newA);
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Generator Property Iterator");
            jf.getContentPane().setLayout(new BorderLayout());
            GeneratorPropertyIteratorPanel gp = new GeneratorPropertyIteratorPanel();
            jf.getContentPane().add((Component)gp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            System.err.println("Short nap");
            Thread.sleep(3000L);
            System.err.println("Done");
            gp.setExperiment(new Experiment());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

