/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;

public abstract class SimpleFilter
extends Filter
implements OptionHandler {
    private static final long serialVersionUID = 5702974949137433141L;
    protected boolean m_Debug = false;
    protected boolean m_DoNotCheckCapabilities = false;

    public abstract String globalInfo();

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tIf set, filter is run in debug mode and\n\tmay output additional info to the console", "output-debug-info", 0, "-output-debug-info"));
        newVector.addElement(new Option("\tIf set, filter capabilities are not checked when input format is set\n\t(use with caution).", "-do-not-check-capabilities", 0, "-do-not-check-capabilities"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag("output-debug-info", options));
        this.setDoNotCheckCapabilities(Utils.getFlag("do-not-check-capabilities", options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getDebug()) {
            options.add("-output-debug-info");
        }
        if (this.getDoNotCheckCapabilities()) {
            options.add("-do-not-check-capabilities");
        }
        return options.toArray(new String[0]);
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, filter may output additional info to the console.";
    }

    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
        this.m_DoNotCheckCapabilities = doNotCheckCapabilities;
    }

    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    public String doNotCheckCapabilitiesTipText() {
        return "If set, filter capabilities are not checked when input format is set (Use with caution to reduce runtime).";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.setTestWithFailAlwaysSucceeds(this.getDoNotCheckCapabilities());
        return result;
    }

    protected void reset() {
        this.m_NewBatch = true;
        this.m_FirstBatchDone = false;
    }

    protected abstract boolean hasImmediateOutputFormat();

    protected abstract Instances determineOutputFormat(Instances var1) throws Exception;

    protected abstract Instances process(Instances var1) throws Exception;

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.reset();
        if (this.hasImmediateOutputFormat()) {
            this.setOutputFormat(this.determineOutputFormat(instanceInfo));
        }
        return this.hasImmediateOutputFormat();
    }
}

