/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class BVDecomposeSegCVSub
implements OptionHandler,
TechnicalInformationHandler,
RevisionHandler {
    protected boolean m_Debug;
    protected Classifier m_Classifier = new ZeroR();
    protected String[] m_ClassifierOptions;
    protected int m_ClassifyIterations;
    protected String m_DataFileName;
    protected int m_ClassIndex = -1;
    protected int m_Seed = 1;
    protected double m_KWBias;
    protected double m_KWVariance;
    protected double m_KWSigma;
    protected double m_WBias;
    protected double m_WVariance;
    protected double m_Error;
    protected int m_TrainSize;
    protected double m_P;

    public String globalInfo() {
        return "This class performs Bias-Variance decomposion on any classifier using the sub-sampled cross-validation procedure as specified in (1).\nThe Kohavi and Wolpert definition of bias and variance is specified in (2).\nThe Webb definition of bias and variance is specified in (3).\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Geoffrey I. Webb and Paul Conilione");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.TITLE, "Estimating bias and variance from data");
        result.setValue(TechnicalInformation.Field.INSTITUTION, "Monash University");
        result.setValue(TechnicalInformation.Field.ADDRESS, "School of Computer Science and Software Engineering, Victoria, Australia");
        result.setValue(TechnicalInformation.Field.PDF, "http://www.csse.monash.edu.au/~webb/Files/WebbConilione04.pdf");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Ron Kohavi and David H. Wolpert");
        additional.setValue(TechnicalInformation.Field.YEAR, "1996");
        additional.setValue(TechnicalInformation.Field.TITLE, "Bias Plus Variance Decomposition for Zero-One Loss Functions");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Machine Learning: Proceedings of the Thirteenth International Conference");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        additional.setValue(TechnicalInformation.Field.EDITOR, "Lorenza Saitta");
        additional.setValue(TechnicalInformation.Field.PAGES, "275-283");
        additional.setValue(TechnicalInformation.Field.PS, "http://robotics.stanford.edu/~ronnyk/biasVar.ps");
        additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Geoffrey I. Webb");
        additional.setValue(TechnicalInformation.Field.YEAR, "2000");
        additional.setValue(TechnicalInformation.Field.TITLE, "MultiBoosting: A Technique for Combining Boosting and Wagging");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        additional.setValue(TechnicalInformation.Field.VOLUME, "40");
        additional.setValue(TechnicalInformation.Field.NUMBER, "2");
        additional.setValue(TechnicalInformation.Field.PAGES, "159-196");
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(8);
        newVector.addElement(new Option("\tThe index of the class attribute.\n\t(default last)", "c", 1, "-c <class index>"));
        newVector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        newVector.addElement(new Option("\tThe number of times each instance is classified.\n\t(default 10)", "l", 1, "-l <num>"));
        newVector.addElement(new Option("\tThe average proportion of instances common between any two training sets", "p", 1, "-p <proportion of objects in common>"));
        newVector.addElement(new Option("\tThe random number seed used.", "s", 1, "-s <seed>"));
        newVector.addElement(new Option("\tThe name of the arff file used for the decomposition.", "t", 1, "-t <name of arff file>"));
        newVector.addElement(new Option("\tThe number of instances in the training set.", "T", 1, "-T <number of instances in training set>"));
        newVector.addElement(new Option("\tFull class name of the learner used in the decomposition.\n\teg: weka.classifiers.bayes.NaiveBayes", "W", 1, "-W <classifier class name>"));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to learner " + this.m_Classifier.getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)((Object)this.m_Classifier)).listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        String classIndex = Utils.getOption('c', options);
        if (classIndex.length() != 0) {
            if (classIndex.toLowerCase().equals("last")) {
                this.setClassIndex(0);
            } else if (classIndex.toLowerCase().equals("first")) {
                this.setClassIndex(1);
            } else {
                this.setClassIndex(Integer.parseInt(classIndex));
            }
        } else {
            this.setClassIndex(0);
        }
        String classifyIterations = Utils.getOption('l', options);
        if (classifyIterations.length() != 0) {
            this.setClassifyIterations(Integer.parseInt(classifyIterations));
        } else {
            this.setClassifyIterations(10);
        }
        String prob = Utils.getOption('p', options);
        if (prob.length() != 0) {
            this.setP(Double.parseDouble(prob));
        } else {
            this.setP(-1.0);
        }
        String seedString = Utils.getOption('s', options);
        if (seedString.length() != 0) {
            this.setSeed(Integer.parseInt(seedString));
        } else {
            this.setSeed(1);
        }
        String dataFile = Utils.getOption('t', options);
        if (dataFile.length() == 0) {
            throw new Exception("An arff file must be specified with the -t option.");
        }
        this.setDataFileName(dataFile);
        String trainSize = Utils.getOption('T', options);
        if (trainSize.length() != 0) {
            this.setTrainSize(Integer.parseInt(trainSize));
        } else {
            this.setTrainSize(-1);
        }
        String classifierName = Utils.getOption('W', options);
        if (classifierName.length() == 0) {
            throw new Exception("A learner must be specified with the -W option.");
        }
        this.setClassifier(AbstractClassifier.forName(classifierName, Utils.partitionOptions(options)));
    }

    @Override
    public String[] getOptions() {
        String[] classifierOptions = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            classifierOptions = ((OptionHandler)((Object)this.m_Classifier)).getOptions();
        }
        String[] options = new String[classifierOptions.length + 14];
        int current = 0;
        if (this.getDebug()) {
            options[current++] = "-D";
        }
        options[current++] = "-c";
        options[current++] = "" + this.getClassIndex();
        options[current++] = "-l";
        options[current++] = "" + this.getClassifyIterations();
        options[current++] = "-p";
        options[current++] = "" + this.getP();
        options[current++] = "-s";
        options[current++] = "" + this.getSeed();
        if (this.getDataFileName() != null) {
            options[current++] = "-t";
            options[current++] = this.getDataFileName();
        }
        options[current++] = "-T";
        options[current++] = "" + this.getTrainSize();
        if (this.getClassifier() != null) {
            options[current++] = "-W";
            options[current++] = this.getClassifier().getClass().getName();
        }
        options[current++] = "--";
        System.arraycopy(classifierOptions, 0, options, current, classifierOptions.length);
        current += classifierOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_Classifier = newClassifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setSeed(int seed) {
        this.m_Seed = seed;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setClassifyIterations(int classifyIterations) {
        this.m_ClassifyIterations = classifyIterations;
    }

    public int getClassifyIterations() {
        return this.m_ClassifyIterations;
    }

    public void setDataFileName(String dataFileName) {
        this.m_DataFileName = dataFileName;
    }

    public String getDataFileName() {
        return this.m_DataFileName;
    }

    public int getClassIndex() {
        return this.m_ClassIndex + 1;
    }

    public void setClassIndex(int classIndex) {
        this.m_ClassIndex = classIndex - 1;
    }

    public double getKWBias() {
        return this.m_KWBias;
    }

    public double getWBias() {
        return this.m_WBias;
    }

    public double getKWVariance() {
        return this.m_KWVariance;
    }

    public double getWVariance() {
        return this.m_WVariance;
    }

    public double getKWSigma() {
        return this.m_KWSigma;
    }

    public void setTrainSize(int size) {
        this.m_TrainSize = size;
    }

    public int getTrainSize() {
        return this.m_TrainSize;
    }

    public void setP(double proportion) {
        this.m_P = proportion;
    }

    public double getP() {
        return this.m_P;
    }

    public double getError() {
        return this.m_Error;
    }

    public void decompose() throws Exception {
        int index;
        BufferedReader dataReader = new BufferedReader(new FileReader(this.m_DataFileName));
        Instances data = new Instances(dataReader);
        if (this.m_ClassIndex < 0) {
            data.setClassIndex(data.numAttributes() - 1);
        } else {
            data.setClassIndex(this.m_ClassIndex);
        }
        if (data.classAttribute().type() != 1) {
            throw new Exception("Class attribute must be nominal");
        }
        int numClasses = data.numClasses();
        data.deleteWithMissingClass();
        if (data.checkForStringAttributes()) {
            throw new Exception("Can't handle string attributes!");
        }
        if (data.numInstances() <= 2) {
            throw new Exception("Dataset size must be greater than 2.");
        }
        if (this.m_TrainSize == -1) {
            this.m_TrainSize = (int)Math.floor((double)data.numInstances() / 2.0);
        } else if (this.m_TrainSize < 0 || this.m_TrainSize >= data.numInstances() - 1) {
            throw new Exception("Training set size of " + this.m_TrainSize + " is invalid.");
        }
        if (this.m_P == -1.0) {
            this.m_P = (double)this.m_TrainSize / ((double)data.numInstances() - 1.0);
        } else if (this.m_P < (double)this.m_TrainSize / ((double)data.numInstances() - 1.0) || this.m_P >= 1.0) {
            throw new Exception("Proportion is not in range: " + (double)this.m_TrainSize / ((double)data.numInstances() - 1.0) + " <= p < 1.0 ");
        }
        int tps = (int)Math.ceil((double)this.m_TrainSize / this.m_P + 1.0);
        int k = (int)Math.ceil((double)tps / ((double)tps - (double)this.m_TrainSize));
        if (k > tps) {
            throw new Exception("The required number of folds is too many.Change p or the size of the training set.");
        }
        int q = (int)Math.floor((double)data.numInstances() / (double)tps);
        double[][] instanceProbs = new double[data.numInstances()][numClasses];
        int[][] foldIndex = new int[k][2];
        Vector<int[]> segmentList = new Vector<int[]>(q + 1);
        Random random = new Random(this.m_Seed);
        data.randomize(random);
        int currentDataIndex = 0;
        int count = 1;
        while (count <= q + 1) {
            int[] segmentIndex;
            if (count > q) {
                segmentIndex = new int[data.numInstances() - q * tps];
                index = 0;
                while (index < segmentIndex.length) {
                    segmentIndex[index] = currentDataIndex++;
                    ++index;
                }
                segmentList.add(segmentIndex);
            } else {
                segmentIndex = new int[tps];
                index = 0;
                while (index < segmentIndex.length) {
                    segmentIndex[index] = currentDataIndex++;
                    ++index;
                }
                segmentList.add(segmentIndex);
            }
            ++count;
        }
        int remainder = tps % k;
        int foldSize = (int)Math.ceil((double)tps / (double)k);
        index = 0;
        int count2 = 0;
        while (count2 < k) {
            if (remainder == 0 || count2 == remainder) {
                // empty if block
            }
            foldIndex[count2][0] = index;
            foldIndex[count2][1] = --foldSize;
            index += foldSize;
            ++count2;
        }
        int l = 0;
        while (l < this.m_ClassifyIterations) {
            int i = 1;
            while (i <= q) {
                int[] currentSegment = (int[])segmentList.get(i - 1);
                this.randomize(currentSegment, random);
                int j = 1;
                while (j <= k) {
                    Instances TP = null;
                    int foldNum = 1;
                    while (foldNum <= k) {
                        if (foldNum != j) {
                            int startFoldIndex = foldIndex[foldNum - 1][0];
                            foldSize = foldIndex[foldNum - 1][1];
                            int endFoldIndex = startFoldIndex + foldSize - 1;
                            int currentFoldIndex = startFoldIndex;
                            while (currentFoldIndex <= endFoldIndex) {
                                if (TP == null) {
                                    TP = new Instances(data, currentSegment[currentFoldIndex], 1);
                                } else {
                                    TP.add(data.instance(currentSegment[currentFoldIndex]));
                                }
                                ++currentFoldIndex;
                            }
                        }
                        ++foldNum;
                    }
                    TP.randomize(random);
                    if (this.getTrainSize() > TP.numInstances()) {
                        throw new Exception("The training set size of " + this.getTrainSize() + ", is greater than the training pool " + TP.numInstances());
                    }
                    Instances train = new Instances(TP, 0, this.m_TrainSize);
                    Classifier current = AbstractClassifier.makeCopy(this.m_Classifier);
                    current.buildClassifier(train);
                    int currentTestIndex = foldIndex[j - 1][0];
                    int testFoldSize = foldIndex[j - 1][1];
                    int endTestIndex = currentTestIndex + testFoldSize - 1;
                    while (currentTestIndex <= endTestIndex) {
                        Instance testInst = data.instance(currentSegment[currentTestIndex]);
                        int pred = (int)current.classifyInstance(testInst);
                        if ((double)pred != testInst.classValue()) {
                            this.m_Error += 1.0;
                        }
                        double[] dArray = instanceProbs[currentSegment[currentTestIndex]];
                        int n = pred;
                        dArray[n] = dArray[n] + 1.0;
                        ++currentTestIndex;
                    }
                    if (i == 1 && j == 1) {
                        int[] segmentElast = (int[])segmentList.lastElement();
                        int currentIndex = 0;
                        while (currentIndex < segmentElast.length) {
                            Instance testInst = data.instance(segmentElast[currentIndex]);
                            int pred = (int)current.classifyInstance(testInst);
                            if ((double)pred != testInst.classValue()) {
                                this.m_Error += 1.0;
                            }
                            double[] dArray = instanceProbs[segmentElast[currentIndex]];
                            int n = pred;
                            dArray[n] = dArray[n] + 1.0;
                            ++currentIndex;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        this.m_Error /= (double)(this.m_ClassifyIterations * data.numInstances());
        this.m_KWBias = 0.0;
        this.m_KWVariance = 0.0;
        this.m_KWSigma = 0.0;
        this.m_WBias = 0.0;
        this.m_WVariance = 0.0;
        int i = 0;
        while (i < data.numInstances()) {
            Instance current = data.instance(i);
            double[] predProbs = instanceProbs[i];
            double bsum = 0.0;
            double vsum = 0.0;
            double ssum = 0.0;
            double wBSum = 0.0;
            double wVSum = 0.0;
            Vector<Integer> centralTendencies = this.findCentralTendencies(predProbs);
            if (centralTendencies == null) {
                throw new Exception("Central tendency was null.");
            }
            int j = 0;
            while (j < numClasses) {
                double pActual = current.classValue() == (double)j ? 1 : 0;
                double pPred = predProbs[j] / (double)this.m_ClassifyIterations;
                bsum += (pActual - pPred) * (pActual - pPred) - pPred * (1.0 - pPred) / (double)(this.m_ClassifyIterations - 1);
                vsum += pPred * pPred;
                ssum += pActual * pActual;
                ++j;
            }
            this.m_KWBias += bsum;
            this.m_KWVariance += 1.0 - vsum;
            this.m_KWSigma += 1.0 - ssum;
            int count3 = 0;
            while (count3 < centralTendencies.size()) {
                int wB = 0;
                int wV = 0;
                int centralTendency = centralTendencies.get(count3);
                int j2 = 0;
                while (j2 < numClasses) {
                    if (j2 != (int)current.classValue() && j2 == centralTendency) {
                        wB = (int)((double)wB + predProbs[j2]);
                    }
                    if (j2 != (int)current.classValue() && j2 != centralTendency) {
                        wV = (int)((double)wV + predProbs[j2]);
                    }
                    ++j2;
                }
                wBSum += (double)wB;
                wVSum += (double)wV;
                ++count3;
            }
            this.m_WBias += wBSum / (double)(centralTendencies.size() * this.m_ClassifyIterations);
            this.m_WVariance += wVSum / (double)(centralTendencies.size() * this.m_ClassifyIterations);
            ++i;
        }
        this.m_KWBias /= 2.0 * (double)data.numInstances();
        this.m_KWVariance /= 2.0 * (double)data.numInstances();
        this.m_KWSigma /= 2.0 * (double)data.numInstances();
        this.m_WBias /= (double)data.numInstances();
        this.m_WVariance /= (double)data.numInstances();
        if (this.m_Debug) {
            System.err.println("Decomposition finished");
        }
    }

    public Vector<Integer> findCentralTendencies(double[] predProbs) {
        int centralTValue = 0;
        int currentValue = 0;
        Vector<Integer> centralTClasses = new Vector<Integer>();
        int i = 0;
        while (i < predProbs.length) {
            currentValue = (int)predProbs[i];
            if (currentValue > centralTValue) {
                centralTClasses.clear();
                centralTClasses.addElement(new Integer(i));
                centralTValue = currentValue;
            } else if (currentValue != 0 && currentValue == centralTValue) {
                centralTClasses.addElement(new Integer(i));
            }
            ++i;
        }
        if (centralTValue != 0) {
            return centralTClasses;
        }
        return null;
    }

    public String toString() {
        String result = "\nBias-Variance Decomposition Segmentation, Cross Validation\nwith subsampling.\n";
        if (this.getClassifier() == null) {
            return "Invalid setup";
        }
        result = String.valueOf(result) + "\nClassifier    : " + this.getClassifier().getClass().getName();
        if (this.getClassifier() instanceof OptionHandler) {
            result = String.valueOf(result) + Utils.joinOptions(((OptionHandler)((Object)this.m_Classifier)).getOptions());
        }
        result = String.valueOf(result) + "\nData File     : " + this.getDataFileName();
        result = String.valueOf(result) + "\nClass Index   : ";
        result = this.getClassIndex() == 0 ? String.valueOf(result) + "last" : String.valueOf(result) + this.getClassIndex();
        result = String.valueOf(result) + "\nIterations    : " + this.getClassifyIterations();
        result = String.valueOf(result) + "\np             : " + this.getP();
        result = String.valueOf(result) + "\nTraining Size : " + this.getTrainSize();
        result = String.valueOf(result) + "\nSeed          : " + this.getSeed();
        result = String.valueOf(result) + "\n\nDefinition   : Kohavi and Wolpert";
        result = String.valueOf(result) + "\nError         :" + Utils.doubleToString(this.getError(), 4);
        result = String.valueOf(result) + "\nBias^2        :" + Utils.doubleToString(this.getKWBias(), 4);
        result = String.valueOf(result) + "\nVariance      :" + Utils.doubleToString(this.getKWVariance(), 4);
        result = String.valueOf(result) + "\nSigma^2       :" + Utils.doubleToString(this.getKWSigma(), 4);
        result = String.valueOf(result) + "\n\nDefinition   : Webb";
        result = String.valueOf(result) + "\nError         :" + Utils.doubleToString(this.getError(), 4);
        result = String.valueOf(result) + "\nBias          :" + Utils.doubleToString(this.getWBias(), 4);
        result = String.valueOf(result) + "\nVariance      :" + Utils.doubleToString(this.getWVariance(), 4);
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10141 $");
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        try {
            block5: {
                bvd = new BVDecomposeSegCVSub();
                try {
                    bvd.setOptions(args);
                    Utils.checkForRemainingOptions(args);
                    break block5;
                }
                catch (Exception ex) {
                    result = String.valueOf(ex.getMessage()) + "\nBVDecompose Options:\n\n";
                    enu = bvd.listOptions();
                    ** while (enu.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    option = enu.nextElement();
                    result = String.valueOf(result) + option.synopsis() + "\n" + option.description() + "\n";
                    continue;
                }
lbl14:
                // 1 sources

                throw new Exception(result);
            }
            bvd.decompose();
            System.out.println(bvd.toString());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public final void randomize(int[] index, Random random) {
        int j = index.length - 1;
        while (j > 0) {
            int k = random.nextInt(j + 1);
            int temp = index[j];
            index[j] = index[k];
            index[k] = temp;
            --j;
        }
    }
}

