/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.classifiers.rules.ZeroR;
import weka.core.Check;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class CheckGOE
extends Check {
    protected Object m_Object = new ZeroR();
    protected boolean m_Success;
    protected HashSet<String> m_IgnoredProperties = new HashSet();

    public CheckGOE() {
        try {
            this.setOptions(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addAll(Collections.list(super.listOptions()));
        result.addElement(new Option("\tSkipped properties.\n\t(default: capabilities,options)", "ignored", 1, "-ignored <comma-separated list of properties>"));
        result.addElement(new Option("\tFull name of the class analysed.\n\teg: weka.classifiers.rules.ZeroR\n\t(default weka.classifiers.rules.ZeroR)", "W", 1, "-W"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() == 0) {
            tmpStr = ZeroR.class.getName();
        }
        this.setObject(Utils.forName(Object.class, tmpStr, null));
        tmpStr = Utils.getOption("ignored", options);
        if (tmpStr.length() == 0) {
            tmpStr = "capabilities,options";
        }
        this.setIgnoredProperties(tmpStr);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        Collections.addAll(result, super.getOptions());
        result.add("-ignored");
        result.add(this.getIgnoredProperties());
        if (this.getObject() != null) {
            result.add("-W");
            result.add(this.getObject().getClass().getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public void setObject(Object value) {
        this.m_Object = value;
    }

    public Object getObject() {
        return this.m_Object;
    }

    public void setIgnoredProperties(String value) {
        this.m_IgnoredProperties.clear();
        String[] props = value.split(",");
        int i = 0;
        while (i < props.length) {
            this.m_IgnoredProperties.add(props[i]);
            ++i;
        }
    }

    public String getIgnoredProperties() {
        Vector<String> list = new Vector<String>();
        list.addAll(this.m_IgnoredProperties);
        if (list.size() > 1) {
            Collections.sort(list);
        }
        String result = "";
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + (String)list.get(i);
            ++i;
        }
        return result;
    }

    public boolean getSuccess() {
        return this.m_Success;
    }

    public boolean checkGlobalInfo() {
        this.print("Global info...");
        boolean result = true;
        Class<?> cls = this.getObject().getClass();
        try {
            cls.getMethod("globalInfo", null);
        }
        catch (Exception e) {
            result = false;
        }
        if (result) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return result;
    }

    public boolean checkToolTips() {
        PropertyDescriptor[] desc;
        this.print("Tool tips...");
        boolean result = true;
        String suffix = "TipText";
        Class<?> cls = this.getObject().getClass();
        try {
            BeanInfo info = Introspector.getBeanInfo(cls, Object.class);
            desc = info.getPropertyDescriptors();
        }
        catch (Exception e) {
            e.printStackTrace();
            desc = null;
        }
        if (desc != null) {
            Vector<String> missing = new Vector<String>();
            int i = 0;
            while (i < desc.length) {
                if (!this.m_IgnoredProperties.contains(desc[i].getName()) && desc[i].getReadMethod() != null && desc[i].getWriteMethod() != null) {
                    try {
                        cls.getMethod(String.valueOf(desc[i].getName()) + suffix, null);
                    }
                    catch (Exception e) {
                        result = false;
                        missing.add(String.valueOf(desc[i].getName()) + suffix);
                    }
                }
                ++i;
            }
            if (result) {
                this.println("yes");
            } else {
                this.println("no (missing: " + missing + ")");
            }
        } else {
            this.println("maybe");
        }
        return result;
    }

    @Override
    public void doTests() {
        this.println("Object: " + this.m_Object.getClass().getName() + "\n");
        this.println("--> Tests");
        this.m_Success = this.checkGlobalInfo();
        if (this.m_Success) {
            this.m_Success = this.checkToolTips();
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }

    public static void main(String[] args) {
        CheckGOE check = new CheckGOE();
        CheckGOE.runCheck(check, args);
        if (check.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

