/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Arrays;
import weka.core.Optimization;
import weka.core.RevisionHandler;
import weka.core.TechnicalInformation;

public abstract class ConjugateGradientOptimization
extends Optimization
implements RevisionHandler {
    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Y.H. Dai and Y. Yuan");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "An Efficient Hybrid Conjugate Gradient Method for Unconstrained Optimization");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Annals of Operations Research");
        result.setValue(TechnicalInformation.Field.VOLUME, "103");
        result.setValue(TechnicalInformation.Field.PAGES, "33-47");
        result.add(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "W.W. Hager and H. Zhang");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        result.setValue(TechnicalInformation.Field.TITLE, "A survey of nonlinear conjugate gradient methods");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pacific Journal of Optimization");
        result.setValue(TechnicalInformation.Field.VOLUME, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "35-58");
        return result;
    }

    public ConjugateGradientOptimization() {
        this.setMaxIteration(2000);
        this.m_BETA = 0.1;
    }

    @Override
    public double[] findArgmin(double[] initX, double[][] constraints) throws Exception {
        int l = initX.length;
        this.m_f = this.objectiveFunction(initX);
        if (Double.isNaN(this.m_f)) {
            throw new Exception("Objective function value is NaN!");
        }
        double[] grad = this.evaluateGradient(initX);
        double[] deltaX = new double[l];
        double[] direct = new double[l];
        double[] x = new double[l];
        double sum = 0.0;
        int i = 0;
        while (i < grad.length) {
            direct[i] = -grad[i];
            sum += grad[i] * grad[i];
            ++i;
        }
        double stpmax = this.m_STPMX * Math.max(Math.sqrt(sum), (double)l);
        boolean[] isFixed = new boolean[initX.length];
        Optimization.DynamicIntArray wsBdsIndx = new Optimization.DynamicIntArray(this, initX.length);
        double[][] consts = new double[2][initX.length];
        int i2 = 0;
        while (i2 < initX.length) {
            if (!Double.isNaN(constraints[0][i2]) || !Double.isNaN(constraints[1][i2])) {
                throw new Exception("Cannot deal with constraints, sorry.");
            }
            consts[0][i2] = constraints[0][i2];
            consts[1][i2] = constraints[1][i2];
            x[i2] = initX[i2];
            ++i2;
        }
        boolean finished = false;
        int step = 0;
        while (step < this.m_MAXITS) {
            double tmp;
            if (m_Debug) {
                System.err.println("\nIteration # " + step + ":");
            }
            double[] oldX = x;
            double[] oldGrad = grad;
            double[] directB = Arrays.copyOf(direct, direct.length);
            this.m_IsZeroStep = false;
            x = this.lnsrch(x, grad, directB, stpmax, isFixed, constraints, wsBdsIndx);
            if (this.m_IsZeroStep) {
                throw new Exception("Exiting due to zero step.");
            }
            double test = 0.0;
            int h = 0;
            while (h < x.length) {
                deltaX[h] = x[h] - oldX[h];
                tmp = Math.abs(deltaX[h]) / Math.max(Math.abs(x[h]), 1.0);
                if (tmp > test) {
                    test = tmp;
                }
                ++h;
            }
            if (test < m_Zero) {
                if (m_Debug) {
                    System.err.println("\nDeltaX converged: " + test);
                }
                finished = true;
                break;
            }
            grad = this.evaluateGradient(x);
            test = 0.0;
            int g = 0;
            while (g < l) {
                tmp = Math.abs(grad[g]) * Math.max(Math.abs(directB[g]), 1.0) / Math.max(Math.abs(this.m_f), 1.0);
                if (tmp > test) {
                    test = tmp;
                }
                ++g;
            }
            if (test < m_Zero) {
                if (m_Debug) {
                    int i3 = 0;
                    while (i3 < l) {
                        System.out.println(String.valueOf(grad[i3]) + " " + directB[i3] + " " + this.m_f);
                        ++i3;
                    }
                    System.err.println("Gradient converged: " + test);
                }
                finished = true;
                break;
            }
            double betaHSNumerator = 0.0;
            double betaDYNumerator = 0.0;
            double betaHSandDYDenominator = 0.0;
            int i4 = 0;
            while (i4 < grad.length) {
                betaDYNumerator += grad[i4] * grad[i4];
                betaHSNumerator += (grad[i4] - oldGrad[i4]) * grad[i4];
                betaHSandDYDenominator += (grad[i4] - oldGrad[i4]) * direct[i4];
                ++i4;
            }
            double betaHS = betaHSNumerator / betaHSandDYDenominator;
            double betaDY = betaDYNumerator / betaHSandDYDenominator;
            if (m_Debug) {
                System.err.println("Beta HS: " + betaHS);
                System.err.println("Beta DY: " + betaDY);
            }
            int i5 = 0;
            while (i5 < direct.length) {
                direct[i5] = -grad[i5] + Math.max(0.0, Math.min(betaHS, betaDY)) * direct[i5];
                ++i5;
            }
            ++step;
        }
        if (finished) {
            if (m_Debug) {
                System.err.println("Minimum found.");
            }
            this.m_f = this.objectiveFunction(x);
            if (Double.isNaN(this.m_f)) {
                throw new Exception("Objective function value is NaN!");
            }
            return x;
        }
        if (m_Debug) {
            System.err.println("Cannot find minimum -- too many iterations!");
        }
        this.m_X = x;
        return null;
    }
}

