/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;

public class BIFParser
implements GraphConstants {
    protected ArrayList<GraphNode> m_nodes;
    protected ArrayList<GraphEdge> m_edges;
    protected String graphName;
    protected String inString;
    protected InputStream inStream;

    public BIFParser(String input, ArrayList<GraphNode> nodes, ArrayList<GraphEdge> edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.inString = input;
    }

    public BIFParser(InputStream instream, ArrayList<GraphNode> nodes, ArrayList<GraphEdge> edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.inStream = instream;
    }

    public String parse() throws Exception {
        int k;
        GraphNode n2;
        int j;
        GraphNode n;
        Document dc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (this.inStream != null) {
            dc = db.parse(this.inStream);
        } else if (this.inString != null) {
            dc = db.parse(new InputSource(new StringReader(this.inString)));
        } else {
            throw new Exception("No input given");
        }
        NodeList nl = dc.getElementsByTagName("NETWORK");
        if (nl.getLength() == 0) {
            throw new BIFFormatException("NETWORK tag not found");
        }
        NodeList templist = ((Element)nl.item(0)).getElementsByTagName("NAME");
        this.graphName = templist.item(0).getFirstChild().getNodeValue();
        nl = dc.getElementsByTagName("VARIABLE");
        int i = 0;
        while (i < nl.getLength()) {
            templist = ((Element)nl.item(i)).getElementsByTagName("NAME");
            if (templist.getLength() > 1) {
                throw new BIFFormatException("More than one name tags found for variable no. " + (i + 1));
            }
            String nodename = templist.item(0).getFirstChild().getNodeValue();
            n = new GraphNode(nodename, nodename, 3);
            this.m_nodes.add(n);
            templist = ((Element)nl.item(i)).getElementsByTagName("PROPERTY");
            j = 0;
            while (j < templist.getLength()) {
                if (templist.item(j).getFirstChild().getNodeValue().startsWith("position")) {
                    String xy = templist.item(j).getFirstChild().getNodeValue();
                    n.x = Integer.parseInt(xy.substring(xy.indexOf(40) + 1, xy.indexOf(44)).trim());
                    n.y = Integer.parseInt(xy.substring(xy.indexOf(44) + 1, xy.indexOf(41)).trim());
                    break;
                }
                ++j;
            }
            templist = ((Element)nl.item(i)).getElementsByTagName("OUTCOME");
            n.outcomes = new String[templist.getLength()];
            j = 0;
            while (j < templist.getLength()) {
                n.outcomes[j] = templist.item(j).getFirstChild().getNodeValue();
                ++j;
            }
            ++i;
        }
        nl = dc.getElementsByTagName("DEFINITION");
        i = 0;
        while (i < nl.getLength()) {
            templist = ((Element)nl.item(i)).getElementsByTagName("FOR");
            String nid = templist.item(0).getFirstChild().getNodeValue();
            n = this.m_nodes.get(0);
            j = 1;
            while (j < this.m_nodes.size() && !n.ID.equals(nid)) {
                n = this.m_nodes.get(j);
                ++j;
            }
            templist = ((Element)nl.item(i)).getElementsByTagName("GIVEN");
            int parntOutcomes = 1;
            int j2 = 0;
            while (j2 < templist.getLength()) {
                nid = templist.item(j2).getFirstChild().getNodeValue();
                n2 = this.m_nodes.get(0);
                k = 1;
                while (k < this.m_nodes.size() && !n2.ID.equals(nid)) {
                    n2 = this.m_nodes.get(k);
                    ++k;
                }
                this.m_edges.add(new GraphEdge(this.m_nodes.indexOf(n2), this.m_nodes.indexOf(n), 1));
                parntOutcomes *= n2.outcomes.length;
                ++j2;
            }
            templist = ((Element)nl.item(i)).getElementsByTagName("TABLE");
            if (templist.getLength() > 1) {
                throw new BIFFormatException("More than one Probability Table for " + n.ID);
            }
            String probs = templist.item(0).getFirstChild().getNodeValue();
            StringTokenizer tk = new StringTokenizer(probs, " \n\t");
            if (parntOutcomes * n.outcomes.length > tk.countTokens()) {
                throw new BIFFormatException("Probability Table for " + n.ID + " contains more values than it should");
            }
            if (parntOutcomes * n.outcomes.length < tk.countTokens()) {
                throw new BIFFormatException("Probability Table for " + n.ID + " contains less values than it should");
            }
            n.probs = new double[parntOutcomes][n.outcomes.length];
            int r = 0;
            while (r < parntOutcomes) {
                int c = 0;
                while (c < n.outcomes.length) {
                    n.probs[r][c] = Double.parseDouble(tk.nextToken());
                    ++c;
                }
                ++r;
            }
            ++i;
        }
        int[] noOfEdgesOfNode = new int[this.m_nodes.size()];
        int[] noOfPrntsOfNode = new int[this.m_nodes.size()];
        int i2 = 0;
        while (i2 < this.m_edges.size()) {
            GraphEdge e = this.m_edges.get(i2);
            int n3 = e.src;
            noOfEdgesOfNode[n3] = noOfEdgesOfNode[n3] + 1;
            int n4 = e.dest;
            noOfPrntsOfNode[n4] = noOfPrntsOfNode[n4] + 1;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_edges.size()) {
            GraphEdge e = this.m_edges.get(i2);
            GraphNode n5 = this.m_nodes.get(e.src);
            n2 = this.m_nodes.get(e.dest);
            if (n5.edges == null) {
                n5.edges = new int[noOfEdgesOfNode[e.src]][2];
                k = 0;
                while (k < n5.edges.length) {
                    n5.edges[k][0] = -1;
                    ++k;
                }
            }
            if (n2.prnts == null) {
                n2.prnts = new int[noOfPrntsOfNode[e.dest]];
                k = 0;
                while (k < n2.prnts.length) {
                    n2.prnts[k] = -1;
                    ++k;
                }
            }
            k = 0;
            while (n5.edges[k][0] != -1) {
                ++k;
            }
            n5.edges[k][0] = e.dest;
            n5.edges[k][1] = e.type;
            k = 0;
            while (n2.prnts[k] != -1) {
                ++k;
            }
            n2.prnts[k] = e.src;
            ++i2;
        }
        return this.graphName;
    }

    public static void writeXMLBIF03(String filename, String graphName, ArrayList<GraphNode> nodes, ArrayList<GraphEdge> edges) {
        try {
            int n;
            GraphNode n2;
            FileWriter outfile = new FileWriter(filename);
            StringBuffer text = new StringBuffer();
            text.append("<?xml version=\"1.0\"?>\n");
            text.append("<!-- DTD for the XMLBIF 0.3 format -->\n");
            text.append("<!DOCTYPE BIF [\n");
            text.append("\t<!ELEMENT BIF ( NETWORK )*>\n");
            text.append("\t      <!ATTLIST BIF VERSION CDATA #REQUIRED>\n");
            text.append("\t<!ELEMENT NETWORK ( NAME, ( PROPERTY | VARIABLE | DEFINITION )* )>\n");
            text.append("\t<!ELEMENT NAME (#PCDATA)>\n");
            text.append("\t<!ELEMENT VARIABLE ( NAME, ( OUTCOME |  PROPERTY )* ) >\n");
            text.append("\t      <!ATTLIST VARIABLE TYPE (nature|decision|utility) \"nature\">\n");
            text.append("\t<!ELEMENT OUTCOME (#PCDATA)>\n");
            text.append("\t<!ELEMENT DEFINITION ( FOR | GIVEN | TABLE | PROPERTY )* >\n");
            text.append("\t<!ELEMENT FOR (#PCDATA)>\n");
            text.append("\t<!ELEMENT GIVEN (#PCDATA)>\n");
            text.append("\t<!ELEMENT TABLE (#PCDATA)>\n");
            text.append("\t<!ELEMENT PROPERTY (#PCDATA)>\n");
            text.append("]>\n");
            text.append("\n");
            text.append("\n");
            text.append("<BIF VERSION=\"0.3\">\n");
            text.append("<NETWORK>\n");
            text.append("<NAME>" + BIFParser.XMLNormalize(graphName) + "</NAME>\n");
            int nodeidx = 0;
            while (nodeidx < nodes.size()) {
                n2 = nodes.get(nodeidx);
                if (n2.nodeType == 3) {
                    text.append("<VARIABLE TYPE=\"nature\">\n");
                    text.append("\t<NAME>" + BIFParser.XMLNormalize(n2.ID) + "</NAME>\n");
                    if (n2.outcomes != null) {
                        String[] stringArray = n2.outcomes;
                        n = n2.outcomes.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String outcome = stringArray[n3];
                            text.append("\t<OUTCOME>" + BIFParser.XMLNormalize(outcome) + "</OUTCOME>\n");
                            ++n3;
                        }
                    } else {
                        text.append("\t<OUTCOME>true</OUTCOME>\n");
                    }
                    text.append("\t<PROPERTY>position = (" + n2.x + "," + n2.y + ")</PROPERTY>\n");
                    text.append("</VARIABLE>\n");
                }
                ++nodeidx;
            }
            nodeidx = 0;
            while (nodeidx < nodes.size()) {
                n2 = nodes.get(nodeidx);
                if (n2.nodeType == 3) {
                    text.append("<DEFINITION>\n");
                    text.append("<FOR>" + BIFParser.XMLNormalize(n2.ID) + "</FOR>\n");
                    int parntOutcomes = 1;
                    if (n2.prnts != null) {
                        int[] nArray = n2.prnts;
                        int n4 = n2.prnts.length;
                        n = 0;
                        while (n < n4) {
                            int prnt2 = nArray[n];
                            GraphNode prnt = nodes.get(prnt2);
                            text.append("\t<GIVEN>" + BIFParser.XMLNormalize(prnt.ID) + "</GIVEN>\n");
                            if (prnt.outcomes != null) {
                                parntOutcomes *= prnt.outcomes.length;
                            }
                            ++n;
                        }
                    }
                    text.append("<TABLE>\n");
                    int i = 0;
                    while (i < parntOutcomes) {
                        if (n2.outcomes != null) {
                            int outidx = 0;
                            while (outidx < n2.outcomes.length) {
                                text.append(String.valueOf(n2.probs[i][outidx]) + " ");
                                ++outidx;
                            }
                        } else {
                            text.append("1");
                        }
                        text.append('\n');
                        ++i;
                    }
                    text.append("</TABLE>\n");
                    text.append("</DEFINITION>\n");
                }
                ++nodeidx;
            }
            text.append("</NETWORK>\n");
            text.append("</BIF>\n");
            outfile.write(text.toString());
            outfile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static String XMLNormalize(String sStr) {
        StringBuffer sStr2 = new StringBuffer();
        int iStr = 0;
        while (iStr < sStr.length()) {
            char c = sStr.charAt(iStr);
            switch (c) {
                case '&': {
                    sStr2.append("&amp;");
                    break;
                }
                case '\'': {
                    sStr2.append("&apos;");
                    break;
                }
                case '\"': {
                    sStr2.append("&quot;");
                    break;
                }
                case '<': {
                    sStr2.append("&lt;");
                    break;
                }
                case '>': {
                    sStr2.append("&gt;");
                    break;
                }
                default: {
                    sStr2.append(c);
                }
            }
            ++iStr;
        }
        return sStr2.toString();
    }
}

