/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.util.console;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GlobalDataContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static transient GlobalDataContainer theInstance = null;
    private Map<String, Object> dataObjects = new HashMap<String, Object>();

    public static GlobalDataContainer getInstance() {
        if (theInstance == null) {
            theInstance = new GlobalDataContainer();
        }
        return theInstance;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.dataObjects);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (theInstance == null) {
            theInstance = new GlobalDataContainer();
        }
        GlobalDataContainer.theInstance.dataObjects = (Map)s.readObject();
    }

    private Object readResolve() {
        return theInstance;
    }

    private GlobalDataContainer() {
    }

    public boolean addData(String key, Object data) {
        Object previousEntry = this.dataObjects.put(key, data);
        return previousEntry != null;
    }

    public boolean removeData(String key) {
        Object previousEntry = this.dataObjects.remove(key);
        return previousEntry != null;
    }

    public Object getData(String key) {
        return this.dataObjects.get(key);
    }

    public void reset() {
        this.dataObjects = new HashMap<String, Object>();
    }

    public Collection<String> getAllKeys() {
        return this.dataObjects.keySet();
    }
}

