/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolType;

public class EolFormalParameter {
    protected AST ast;
    protected String name;
    protected String typeName = "";
    protected AST typeAst;
    protected EolType type;

    public EolFormalParameter(AST ast) {
        this.parse(ast);
    }

    public void parse(AST ast) {
        this.ast = ast;
        this.name = ast.getFirstChild().getText();
        this.typeAst = ast.getFirstChild().getNextSibling();
        if (this.typeAst != null) {
            this.typeName = this.typeAst.getText();
        }
    }

    public AST getAst() {
        return this.ast;
    }

    public AST getTypeAst() {
        return this.ast.getFirstChild().getNextSibling();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setType(String type) {
        this.typeName = type;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.typeName;
    }

    public EolType getType(IEolContext context) throws EolRuntimeException {
        if (this.type == null) {
            this.type = this.typeAst != null ? (EolType)context.getExecutorFactory().executeAST(this.typeAst, context) : EolAnyType.Instance;
        }
        return this.type;
    }

    public void clearCache() {
        this.type = null;
    }
}

