/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.exceptions;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.IEolLibraryModule;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EolRuntimeException
extends Exception {
    protected AST ast = null;
    protected String reason = "";
    protected IEolContext context = null;

    public EolRuntimeException() {
    }

    public EolRuntimeException(String reason) {
        super(reason);
        this.reason = reason;
    }

    public EolRuntimeException(String reason, AST ast) {
        super(reason);
        this.ast = ast;
        this.reason = reason;
    }

    public AST getAst() {
        return this.ast;
    }

    public void setAst(AST ast) {
        this.ast = ast;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public int getLine() {
        if (this.getAst() != null) {
            return this.getAst().getLine();
        }
        return 0;
    }

    public int getColumn() {
        if (this.getAst() != null) {
            return this.getAst().getColumn();
        }
        return 0;
    }

    @Override
    public String getMessage() {
        IEolContext context;
        String str = this.getReason().replace('(', '[').replace(')', ']');
        if (this.ast != null && this.ast.getModule() instanceof IEolLibraryModule && (context = ((IEolLibraryModule)this.ast.getModule()).getContext()) != null) {
            str = String.valueOf(str) + "\r\n" + context.getExecutorFactory().getStackTraceManager().getStackTraceAsString();
        }
        return str;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public static EolRuntimeException wrap(Throwable t) {
        if (t instanceof EolRuntimeException) {
            return (EolRuntimeException)t;
        }
        return new EolInternalException(t);
    }

    public static void propagate(Throwable t) throws EolRuntimeException {
        throw EolRuntimeException.wrap(t);
    }
}

