/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.TypeInitialiserExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolType;

public class VarStatementExecutor
extends TypeInitialiserExecutor {
    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        AST variableNameAst = ast.getFirstChild();
        AST variableTypeAst = variableNameAst.getNextSibling();
        AST parametersAst = null;
        if (variableTypeAst != null) {
            parametersAst = variableTypeAst.getNextSibling();
        }
        String variableName = variableNameAst.getText();
        EolType variableType = null;
        variableType = variableTypeAst == null ? EolAnyType.Instance : (EolType)context.getExecutorFactory().executeAST(variableTypeAst, context);
        Object newInstance = this.initialiseType(variableType, parametersAst, context, ast.getText().equalsIgnoreCase("new"));
        Variable variable = new Variable(variableName, newInstance, variableType);
        context.getFrameStack().put(variable);
        return variable;
    }
}

