/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection;

import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.ExtendedPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.ExtendedPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertySetter;
import org.eclipse.epsilon.eol.models.IModel;

public class IntrospectionManager {
    protected IPropertyGetter defaultPropertyGetter = new JavaPropertyGetter();
    protected IPropertySetter defaultPropertySetter = new JavaPropertySetter();

    public IPropertySetter getPropertySetterFor(Object object, String property, IEolContext context) {
        IPropertySetter propertySetter = property.startsWith("~") ? new ExtendedPropertySetter(context) : (this.getModelThatKnowsAboutProperty(object, property, context) != null ? this.getModelThatKnowsAboutProperty(object, property, context).getPropertySetter() : this.defaultPropertySetter);
        propertySetter.setProperty(property);
        propertySetter.setObject(object);
        propertySetter.setContext(context);
        return propertySetter;
    }

    public IPropertyGetter getPropertyGetterFor(Object object, String property, IEolContext context) {
        IPropertyGetter propertyGetter = property.startsWith("~") ? new ExtendedPropertyGetter(context) : (this.getModelThatKnowsAboutProperty(object, property, context) != null ? this.getModelThatKnowsAboutProperty(object, property, context).getPropertyGetter() : this.defaultPropertyGetter);
        propertyGetter.setContext(context);
        return propertyGetter;
    }

    public boolean isModelBasedProperty(Object object, String property, IEolContext context) {
        return this.getModelThatKnowsAboutProperty(object, property, context) != null;
    }

    private IModel getModelThatKnowsAboutProperty(Object object, String property, IEolContext context) {
        for (IModel model : context.getModelRepository().getModels()) {
            if (!model.knowsAboutProperty(object, property)) continue;
            return model;
        }
        return null;
    }

    public IPropertyGetter getDefaultPropertyGetter() {
        return this.defaultPropertyGetter;
    }

    public void setDefaultPropertyGetter(IPropertyGetter defaultPropertyGetter) {
        this.defaultPropertyGetter = defaultPropertyGetter;
    }

    public IPropertySetter getDefaultPropertySetter() {
        return this.defaultPropertySetter;
    }

    public void setDefaultPropertySetter(IPropertySetter defaultPropertySetter) {
        this.defaultPropertySetter = defaultPropertySetter;
    }
}

