/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import org.eclipse.epsilon.eol.exceptions.EolAssertionException;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolObjectComparator;

public class BasicEUnitOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return EolNoType.NoInstance.equals(target);
    }

    public void assertTrue(boolean condition) throws EolAssertionException {
        this.assertTrue("Violated assertion", condition);
    }

    public void assertTrue(String message, boolean condition) throws EolAssertionException {
        this.compareBoolean(message, condition, true);
    }

    public void assertFalse(boolean condition) throws EolAssertionException {
        this.assertFalse("Violated assertion", condition);
    }

    public void assertFalse(String message, boolean condition) throws EolAssertionException {
        this.compareBoolean(message, condition, false);
    }

    public void assertEquals(Object expected, Object obtained) throws EolAssertionException {
        String sExpected = this.context.getPrettyPrinterManager().print(expected);
        String sObtained = this.context.getPrettyPrinterManager().print(obtained);
        String message = "Expected " + sExpected + ", but got " + sObtained + " instead";
        this.assertEquals(message, expected, obtained);
    }

    public void assertEquals(String message, Object expected, Object obtained) throws EolAssertionException {
        this.compareGeneric(message, expected, obtained, true);
    }

    public void assertEquals(Number expected, Number obtained, Number ulps) throws EolAssertionException {
        this.assertEquals(null, expected, obtained, ulps);
    }

    public void assertEquals(String message, Number expected, Number obtained, Number ulps) throws EolAssertionException {
        this.compareUlps(message, expected, obtained, ulps, true);
    }

    public void assertNotEquals(Object expected, Object obtained) throws EolAssertionException {
        this.assertNotEquals("Expected something different from " + expected + ", but got something equal to it", expected, obtained);
    }

    public void assertNotEquals(String message, Object expected, Object obtained) throws EolAssertionException {
        this.compareGeneric(message, expected, obtained, false);
    }

    public void assertNotEquals(Number expected, Number obtained, Number ulps) throws EolAssertionException {
        this.assertNotEquals(null, expected, obtained, ulps);
    }

    public void assertNotEquals(String message, Number expected, Number obtained, Number ulps) throws EolAssertionException {
        this.compareUlps(message, expected, obtained, ulps, false);
    }

    public void fail(String message) throws EolAssertionException {
        throw new EolAssertionException(message, this.context.getFrameStack().getCurrentStatement(), null, null, null);
    }

    private void compareBoolean(String message, boolean condition, boolean expected) throws EolAssertionException {
        if (condition != expected) {
            throw new EolAssertionException(this.context.getPrettyPrinterManager().toString(message), this.context.getFrameStack().getCurrentStatement(), expected, condition, null);
        }
    }

    private void compareGeneric(String message, Object expected, Object obtained, boolean mustBeEqual) throws EolAssertionException {
        if (EolObjectComparator.equals(expected, obtained) != mustBeEqual) {
            throw new EolAssertionException(message, this.context.getFrameStack().getCurrentStatement(), expected, obtained, null);
        }
    }

    private void compareUlps(String message, Number expected, Number obtained, Number ulps, boolean mustBeEqual) throws EolAssertionException {
        long intUlps = ulps.longValue();
        boolean bIsEqual = expected == null == (obtained == null);
        String upperBound = null;
        String lowerBound = null;
        if (expected != null) {
            if (expected instanceof Float) {
                float flExpected = expected.floatValue();
                float flMargin = (float)intUlps * Math.ulp(flExpected);
                bIsEqual = bIsEqual && Math.abs(obtained.floatValue() - flExpected) <= flMargin;
                lowerBound = Float.toString(flExpected - flMargin);
                upperBound = Float.toString(flExpected + flMargin);
            } else {
                double dblExpected = expected.doubleValue();
                double dblMargin = (double)intUlps * Math.ulp(dblExpected);
                bIsEqual = bIsEqual && Math.abs(obtained.doubleValue() - dblExpected) <= dblMargin;
                lowerBound = Double.toString(dblExpected - dblMargin);
                upperBound = Double.toString(dblExpected + dblMargin);
            }
        }
        if (bIsEqual != mustBeEqual) {
            if (message == null) {
                message = "Expected " + obtained + (mustBeEqual ? "" : " not") + " to be in [" + lowerBound + ", " + upperBound + "]";
            }
            throw new EolAssertionException(message, this.context.getFrameStack().getCurrentStatement(), expected, obtained != null ? obtained : "null", null);
        }
    }
}

