/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.util;

import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.eclipse.epsilon.eol.util.IdentityBasedWeakReference;

public class Cache<K, V> {
    protected ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    protected HashMap<IdentityBasedWeakReference, V> map = new HashMap();
    protected Thread cleanUpThread = null;

    public HashMap<IdentityBasedWeakReference, V> getMap() {
        return this.map;
    }

    protected Thread createCleanUpThread() {
        return new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (Cache.this.map.size() > 0 && !Thread.currentThread().isInterrupted()) {
                        IdentityBasedWeakReference reference = (IdentityBasedWeakReference)Cache.this.referenceQueue.remove();
                        HashMap hashMap = Cache.this.map;
                        synchronized (hashMap) {
                            if (reference != null && Cache.this.map.containsKey(reference)) {
                                Cache.this.map.remove(reference);
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        HashMap<IdentityBasedWeakReference, V> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.get(new IdentityBasedWeakReference(key, this.referenceQueue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        HashMap<IdentityBasedWeakReference, V> hashMap = this.map;
        synchronized (hashMap) {
            IdentityBasedWeakReference reference = new IdentityBasedWeakReference(key, this.referenceQueue);
            if (!this.map.containsKey(reference)) {
                this.map.put(reference, value);
                if (this.map.size() == 1) {
                    try {
                        this.cleanUpThread = this.createCleanUpThread();
                        this.cleanUpThread.setDaemon(true);
                        this.cleanUpThread.start();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return value;
        }
    }

    public int size() {
        return this.map.size();
    }

    public void dispose() {
        if (this.cleanUpThread != null) {
            this.cleanUpThread.interrupt();
            this.cleanUpThread = null;
        }
        this.map.clear();
    }
}

