/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.erl.exceptions.ErlCircularRuleInheritanceException;
import org.eclipse.epsilon.erl.exceptions.ErlRuleNotFoundException;
import org.eclipse.epsilon.erl.rules.ExtensibleNamedRule;
import org.eclipse.epsilon.erl.rules.INamedRule;

public class NamedRules
extends ArrayList<INamedRule> {
    public INamedRule getRule(String name) {
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            INamedRule rule = (INamedRule)li.next();
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }

    @Override
    public boolean add(INamedRule rule) {
        INamedRule existing;
        if (rule != null && (existing = this.getRule(rule.getName())) != null) {
            this.remove(existing);
        }
        return super.add(rule);
    }

    @Override
    public boolean addAll(Collection<? extends INamedRule> c) {
        boolean result = true;
        for (INamedRule iNamedRule : c) {
            boolean bl = result = this.add(iNamedRule) && result;
        }
        return result;
    }

    public List<ParseProblem> calculateSuperRules(NamedRules allRules) {
        ArrayList<ParseProblem> parseProblems = new ArrayList<ParseProblem>();
        for (INamedRule next : this) {
            ParseProblem problem;
            if (!(next instanceof ExtensibleNamedRule)) continue;
            ExtensibleNamedRule rule = (ExtensibleNamedRule)next;
            try {
                rule.calculateSuperRules(allRules);
            }
            catch (ErlRuleNotFoundException e) {
                problem = new ParseProblem();
                problem.setLine(rule.getAst().getLine());
                problem.setReason(e.getReason());
                parseProblems.add(problem);
            }
            catch (ErlCircularRuleInheritanceException e) {
                problem = new ParseProblem();
                problem.setLine(rule.getAst().getLine());
                problem.setReason(e.getReason());
                parseProblems.add(problem);
            }
        }
        return parseProblems;
    }
}

