/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eunit.EUnitTestResultType;
import org.eclipse.epsilon.eunit.ModelBindings;

public class EUnitTest {
    private EolOperation operation;
    private EUnitTestResultType result = EUnitTestResultType.NOT_RUN_YET;
    private Exception exception;
    private EUnitTest parent;
    private List<EUnitTest> children = new ArrayList<EUnitTest>();
    private String dataVariable;
    private Object dataValue;
    private ModelBindings modelBindings;
    public static final long UNSET_TIME = -1L;
    private long startCpuTime = -1L;
    private long endCpuTime = -1L;
    private long startWallclockTime = -1L;
    private long endWallclockTime = -1L;
    private FrameStack frameStack;

    public EolOperation getOperation() {
        return this.operation;
    }

    public void setOperation(EolOperation operation) {
        this.operation = operation;
    }

    public EUnitTestResultType getResult() {
        return this.result;
    }

    public void setResult(EUnitTestResultType result) {
        this.result = result;
    }

    public Exception getException() {
        if (this.exception != null) {
            return this.exception;
        }
        for (EUnitTest child : this.children) {
            Exception ex = child.getException();
            if (ex == null) continue;
            return ex;
        }
        return null;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public EUnitTest getParent() {
        return this.parent;
    }

    public void setParent(EUnitTest parent) {
        this.parent = parent;
    }

    public String getDataVariableName() {
        return this.dataVariable;
    }

    public void setDataVariableName(String dataVariable) {
        this.dataVariable = dataVariable;
    }

    public Object getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(Object dataValue) {
        this.dataValue = dataValue;
    }

    public List<EUnitTest> getChildren() {
        return this.children;
    }

    public void addChildren(EUnitTest child) {
        this.children.add(child);
    }

    public void setStartCpuTime(long startCpuTime) {
        this.startCpuTime = startCpuTime;
    }

    public long getStartCpuTime() {
        return this.startCpuTime;
    }

    public void setEndCpuTime(long endCpuTime) {
        this.endCpuTime = endCpuTime;
    }

    public long getEndCpuTime() {
        return this.endCpuTime;
    }

    public long getCpuTimeMillis() {
        return (this.getEndCpuTime() - this.getStartCpuTime()) / 1000000L;
    }

    public long getStartWallclockTime() {
        return this.startWallclockTime;
    }

    public void setStartWallclockTime(long startWallclockTime) {
        this.startWallclockTime = startWallclockTime;
    }

    public long getEndWallclockTime() {
        return this.endWallclockTime;
    }

    public void setEndWallclockTime(long endWallclockTime) {
        this.endWallclockTime = endWallclockTime;
    }

    public long getWallclockTimeMillis() {
        return this.getEndWallclockTime() - this.getStartWallclockTime();
    }

    public void setFrameStack(FrameStack frameStack) {
        this.frameStack = frameStack;
    }

    public FrameStack getFrameStack() {
        return this.frameStack;
    }

    public int getPosition() {
        if (this.isRootTest()) {
            return -1;
        }
        int position = 1;
        for (EUnitTest sibling : this.getParent().getChildren()) {
            if (sibling == this) break;
            ++position;
        }
        return position;
    }

    public String getOperationName() {
        return this.getParent() == null ? "root" : this.getOperation().getName();
    }

    public String getCaseName() {
        String sBindings = this.explainAllBindings();
        if (sBindings != null && sBindings.length() > 0) {
            return String.valueOf(this.getOperationName()) + " (" + sBindings + ")";
        }
        return this.getOperationName();
    }

    public String getMethodName() {
        StringBuilder sBuilder = new StringBuilder(this.getOperationName());
        List<EUnitTest> dataBindings = this.getAllBindings();
        for (EUnitTest binding : dataBindings) {
            if (binding.getModelBindings() != null && !binding.getOperationName().equals(binding.getParent().getOperationName())) continue;
            sBuilder.append('[');
            sBuilder.append(binding.getPosition());
            sBuilder.append(']');
        }
        return sBuilder.toString();
    }

    public String explainBinding() {
        if (this.getDataVariableName() == null && this.getModelBindings() == null) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer();
        boolean bFirst = true;
        if (this.getModelBindings() != null) {
            for (Map.Entry<String, String> entry : this.getModelBindings().getMappings().entrySet()) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    sbuf.append(", ");
                }
                sbuf.append("'");
                sbuf.append(entry.getKey());
                sbuf.append("' is '");
                sbuf.append(entry.getValue());
                sbuf.append("'");
            }
        }
        if (this.getDataVariableName() != null) {
            if (!bFirst) {
                sbuf.append(", ");
            }
            sbuf.append(this.getDataVariableName());
            sbuf.append(" = ");
            String sValue = this.getDataValue().toString();
            sbuf.append(sValue);
        }
        return sbuf.toString();
    }

    public String explainAllBindings() {
        List<EUnitTest> lBindings = this.getAllBindings();
        StringBuffer sbuf = new StringBuffer();
        boolean bFirst = true;
        for (EUnitTest t : lBindings) {
            String s = t.explainBinding();
            if (bFirst) {
                bFirst = false;
            } else {
                sbuf.append(", ");
            }
            sbuf.append(s);
        }
        return sbuf.toString();
    }

    public List<EUnitTest> getAllBindings() {
        LinkedList<EUnitTest> lBindings = new LinkedList<EUnitTest>();
        EUnitTest t = this;
        while (t != null) {
            if (t.getDataVariableName() != null || t.getModelBindings() != null) {
                lBindings.add(0, t);
            }
            t = t.getParent();
        }
        return lBindings;
    }

    public String getQualifiedName(String packageName) {
        if (this.getOperation() == null) {
            return String.valueOf(packageName) + ".(root)";
        }
        String filename = this.getOperation().getAst().getBasename();
        int lastDot = filename.lastIndexOf(46);
        if (lastDot != -1) {
            filename = filename.substring(0, lastDot);
        }
        return String.valueOf(packageName) + "." + filename;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(this.getOperationName());
        if (this.getDataVariableName() != null) {
            sbuf.append(" (");
            sbuf.append(this.explainBinding());
            sbuf.append(")");
        }
        if (this.getEndWallclockTime() != -1L) {
            sbuf.append(" [");
            sbuf.append(this.getWallclockTimeMillis());
            sbuf.append("ms]");
        }
        return sbuf.toString();
    }

    public int countLeafTests(List selectedOperations) {
        return this.countLeafTests(selectedOperations, null);
    }

    public int countLeafTests(List selectedOperations, EUnitTestResultType resultFilter) {
        return this.collectLeafTests(selectedOperations, resultFilter).size();
    }

    public List<EUnitTest> collectLeafTests(List selectedOperations, EUnitTestResultType resultFilter) {
        ArrayList<EUnitTest> tests = new ArrayList<EUnitTest>();
        this.collectLeafTests(selectedOperations, resultFilter, tests);
        return tests;
    }

    public void collectLeafTests(List selectedOperations, EUnitTestResultType resultFilter, Collection<EUnitTest> collection) {
        if (!this.isSelected(selectedOperations)) {
            return;
        }
        if (this.isLeafTest()) {
            if (resultFilter == null || resultFilter.equals((Object)this.getResult())) {
                collection.add(this);
            }
        } else {
            for (EUnitTest child : this.getChildren()) {
                child.collectLeafTests(selectedOperations, resultFilter, collection);
            }
        }
    }

    public boolean isSelected(List selectedOperations) {
        return selectedOperations == null || selectedOperations.isEmpty() || this.getOperationName() == null || selectedOperations.contains(this.getOperationName());
    }

    public boolean isLeafTest() {
        return this.getChildren().isEmpty();
    }

    public boolean isRootTest() {
        return this.getParent() == null;
    }

    public synchronized void setModelBindings(ModelBindings mb) throws EolRuntimeException {
        this.modelBindings = mb;
    }

    public synchronized ModelBindings getModelBindings() {
        return this.modelBindings;
    }
}

