/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.typemappings;

import java.util.Collection;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.flock.FlockExecution;
import org.eclipse.epsilon.flock.context.EquivalenceEstablishmentContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.equivalences.TypeBasedEquivalence;
import org.eclipse.epsilon.flock.execution.EolExecutor;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.common.ClassifierTypedConstruct;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstruct;

public class Retyping
extends ClassifierTypedConstruct
implements TypeMappingConstruct {
    private final String evolvedType;

    public Retyping(AST ast, Collection<String> annotations, String originalType, String evolvedType, AST guard) {
        super(ast, annotations, guard, originalType);
        if (evolvedType == null) {
            throw new IllegalArgumentException("evolvedType cannot be null");
        }
        this.evolvedType = evolvedType;
    }

    public Retyping(AST ast, Collection<String> annotations, String originalType, String evolvedType) {
        this(ast, annotations, originalType, evolvedType, null);
    }

    public String getEvolvedType() {
        return this.evolvedType;
    }

    @Override
    public Equivalence createEquivalence(EolExecutor executor, FlockExecution execution, ModelElement original, EquivalenceEstablishmentContext.EquivalentFactory factory) throws FlockRuntimeException {
        ModelElement equivalent = factory.createModelElementInMigratedModel(this.evolvedType);
        return new TypeBasedEquivalence(executor, execution, original, equivalent);
    }

    public String toString() {
        return "retype " + this.getOriginalType() + " to " + this.evolvedType + " when " + this.getGuard();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Retyping)) {
            return false;
        }
        Retyping other = (Retyping)object;
        return super.equals(object) && this.evolvedType.equals(other.evolvedType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.evolvedType.hashCode();
    }
}

