/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.translate;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.antlr.postprocessor.model.antlrAst.Ast;
import org.eclipse.epsilon.antlr.postprocessor.model.antlrAst.Node;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.IEtlModule;
import org.eclipse.epsilon.hutn.exceptions.HutnConfigFileNotFoundException;
import org.eclipse.epsilon.hutn.exceptions.HutnMetaModelRegistrationException;
import org.eclipse.epsilon.hutn.exceptions.HutnTranslationException;
import org.eclipse.epsilon.hutn.exceptions.HutnValidationException;
import org.eclipse.epsilon.hutn.model.config.HutnConfigMetamodel;
import org.eclipse.epsilon.hutn.model.config.hutnConfig.HutnConfigPackage;
import org.eclipse.epsilon.hutn.model.hutn.HutnFactory;
import org.eclipse.epsilon.hutn.model.hutn.HutnPackage;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.model.hutnAntlrAst.HutnAntlrAstPackage;
import org.eclipse.epsilon.hutn.translate.Detail;
import org.eclipse.epsilon.hutn.translate.MetaModelDetail;
import org.eclipse.epsilon.hutn.util.EmcUtil;
import org.eclipse.epsilon.hutn.util.EpsilonUtil;
import org.eclipse.epsilon.hutn.util.StringUtil;
import org.eclipse.epsilon.hutn.validation.config.HutnConfigFileValidator;

public class HutnTranslator {
    private final File configFileDirectory;

    public HutnTranslator() {
        this(null);
    }

    public HutnTranslator(File configFileDirectory) {
        this.configFileDirectory = configFileDirectory;
    }

    private static void registerMetaModels() throws HutnMetaModelRegistrationException {
        EmcUtil.register("http://www.eclipse.org/gmt/epsilon/hutn", HutnPackage.eINSTANCE);
        EmcUtil.register("http://www.eclipse.org/gmt/epsilon/hutnConfig", HutnConfigPackage.eINSTANCE);
        EmcUtil.register("http://www.eclipse.org/gmt/epsilon/hutnAntlrAst", HutnAntlrAstPackage.eINSTANCE);
    }

    private static Node findNodeWithText(List<Node> nodes, String text) {
        for (Node node : nodes) {
            if (!text.equals(node.getText())) continue;
            return node;
        }
        return null;
    }

    private Detail determineDetail(Node metaModelNode, String parent) {
        Node node = HutnTranslator.findNodeWithText(metaModelNode.getChildren(), parent);
        if (node != null && !node.getChildren().isEmpty()) {
            return new Detail(node.getLine(), node.getColumn(), StringUtil.stripQuotes(((Node)node.getChildren().get(0)).getText()));
        }
        return null;
    }

    private MetaModelDetail determineMetaModelDetails(Ast ast) {
        Detail nsUriDetail = null;
        Detail configFileDetail = null;
        Node specNode = HutnTranslator.findNodeWithText(ast.getRoots(), "@Spec");
        if (specNode != null && !specNode.getChildren().isEmpty()) {
            Node metaModelNode = (Node)specNode.getChildren().get(0);
            nsUriDetail = this.determineDetail(metaModelNode, "nsUri");
            configFileDetail = this.determineDetail(metaModelNode, "configFile");
        }
        return new MetaModelDetail(nsUriDetail, configFileDetail);
    }

    private IModel initialiseConfigModel(MetaModelDetail details) throws HutnConfigFileNotFoundException {
        EmfModel configModel = new EmfModel();
        if (details.getConfigFileDetail() == null || details.getConfigFileDetail().getText() == null) {
            configModel.setModelFileUri(HutnConfigMetamodel.getDefaultConfigModelUri());
        } else {
            String configFilePath = details.getConfigFileDetail().getText();
            File configFile = new File(configFilePath);
            if (!configFile.isAbsolute() && this.configFileDirectory != null) {
                configFile = new File(this.configFileDirectory, configFilePath);
            }
            if (configFile.exists()) {
                configModel.setModelFile(configFile.getAbsolutePath());
            } else {
                throw new HutnConfigFileNotFoundException(configFile.getAbsolutePath(), details.getConfigFileDetail().getLine(), details.getConfigFileDetail().getColumn());
            }
        }
        configModel.setName("Config");
        configModel.setMetamodelFileBased(false);
        configModel.setMetamodelUri("http://www.eclipse.org/gmt/epsilon/hutnConfig");
        return configModel;
    }

    public List<ParseProblem> validateConfigModel(Ast ast) throws HutnValidationException, HutnConfigFileNotFoundException {
        LinkedList<ParseProblem> problems = new LinkedList<ParseProblem>();
        MetaModelDetail details = this.determineMetaModelDetails(ast);
        if (details.getConfigFileDetail() != null) {
            if (details.getNsUriDetail() == null) {
                ParseProblem problem = new ParseProblem(details.getConfigFileDetail().getLine(), details.getConfigFileDetail().getColumn(), "No nsUri defined for the metamodel with configFile: " + details.getConfigFileDetail().getText());
                problems.add(problem);
            } else {
                HutnConfigFileValidator validator = new HutnConfigFileValidator(details.getConfigFileDetail().getLine(), details.getConfigFileDetail().getColumn());
                try {
                    HutnTranslator.registerMetaModels();
                }
                catch (HutnMetaModelRegistrationException e) {
                    throw new HutnValidationException(e);
                }
                return validator.getProblemsForConfigurationModel(this.initialiseConfigModel(details), details.getNsUriDetail().getText());
            }
        }
        return problems;
    }

    public Spec createIntermediateModel(Ast ast, File sourceFile) throws HutnTranslationException {
        IModel configModel = this.initialiseConfigModel(this.determineMetaModelDetails(ast));
        try {
            InMemoryEmfModel astModel = new InMemoryEmfModel("AntlrAst", ast.eResource(), HutnAntlrAstPackage.eINSTANCE);
            Spec spec = HutnFactory.eINSTANCE.createSpec();
            spec.setSourceFile(sourceFile == null ? null : sourceFile.getAbsolutePath());
            InMemoryEmfModel intermediateModel = new InMemoryEmfModel("Intermediate", EmfUtil.createResource(spec), HutnPackage.eINSTANCE);
            intermediateModel.setMetamodelFileBased(false);
            intermediateModel.setMetamodelUri("http://www.eclipse.org/gmt/epsilon/hutn");
            HutnTranslator.registerMetaModels();
            IEtlModule transformer = EpsilonUtil.initialiseEtlModule(astModel, intermediateModel, configModel);
            transformer.parse(HutnTranslator.class.getResource("AntlrAst2Intermediate.etl").toURI());
            transformer.execute();
            Spec spec2 = spec;
            return spec2;
        }
        catch (Exception e) {
            if (e instanceof HutnTranslationException) {
                throw (HutnTranslationException)e;
            }
            throw new HutnTranslationException(e);
        }
        finally {
            configModel.dispose();
        }
    }
}

