/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.validation.config;

import java.util.List;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.emc.emf.EmfMetaModel;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.hutn.exceptions.HutnMetaModelRegistrationException;
import org.eclipse.epsilon.hutn.exceptions.HutnValidationException;
import org.eclipse.epsilon.hutn.model.config.hutnConfig.HutnConfigPackage;
import org.eclipse.epsilon.hutn.util.EmcUtil;
import org.eclipse.epsilon.hutn.validation.AbstractValidator;
import org.eclipse.epsilon.hutn.validation.config.HutnConfigFileFixer;

public class HutnConfigFileValidator
extends AbstractValidator {
    HutnConfigFileValidator() {
        this(1, 1);
    }

    public HutnConfigFileValidator(int line, int column) {
        super(new HutnConfigFileFixer(line, column), HutnConfigFileValidator.class.getResource("ValidateConfigurationModel.evl"));
    }

    private static void registerMetaModels() throws HutnMetaModelRegistrationException {
        EmcUtil.register("http://www.eclipse.org/gmt/epsilon/hutnConfig", HutnConfigPackage.eINSTANCE);
    }

    public List<ParseProblem> getProblemsForConfigurationModel(IModel configModel, String metaModelNsUri) throws HutnValidationException {
        try {
            HutnConfigFileValidator.registerMetaModels();
            configModel.load();
            List<ParseProblem> list = this.validate(configModel, new EmfMetaModel("MetaModel", metaModelNsUri));
            return list;
        }
        catch (EolModelLoadingException e) {
            throw new HutnValidationException(e);
        }
        catch (HutnMetaModelRegistrationException e) {
            throw new HutnValidationException(e);
        }
        finally {
            configModel.dispose();
        }
    }
}

