/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.graphml;

import java.io.File;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.graphml.GraphmlImporter;
import org.eclipse.epsilon.emc.muddle.MuddleFactory;
import org.eclipse.epsilon.emc.muddle.MuddleModel;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;

public class GraphmlModel
extends MuddleModel {
    public static final String PROPERTY_FILE = "file";
    protected File file = null;

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        super.load(properties, basePath);
        String filePath = properties.getProperty(PROPERTY_FILE);
        if (filePath != null && filePath.trim().length() > 0) {
            if (basePath != null) {
                filePath = String.valueOf(basePath) + filePath;
            }
            this.file = new File(filePath);
        }
        this.load();
    }

    @Override
    public void load() throws EolModelLoadingException {
        if (this.readOnLoad) {
            GraphmlImporter importer = new GraphmlImporter();
            try {
                this.muddle = importer.importGraph(this.file);
            }
            catch (Exception e) {
                throw new EolModelLoadingException(e, this);
            }
        } else {
            this.muddle = MuddleFactory.eINSTANCE.createMuddle();
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }
}

