/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.Serializable;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Test
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -8890645875887157782L;
    int m_AttIndex;
    double m_Split;
    boolean m_Not;
    Instances m_Dataset;

    public Test(int i, double s, Instances dataset) {
        this.m_AttIndex = i;
        this.m_Split = s;
        this.m_Dataset = dataset;
        this.m_Not = false;
    }

    public Test(int i, double s, Instances dataset, boolean n) {
        this.m_AttIndex = i;
        this.m_Split = s;
        this.m_Dataset = dataset;
        this.m_Not = n;
    }

    public Test getNot() {
        return new Test(this.m_AttIndex, this.m_Split, this.m_Dataset, !this.m_Not);
    }

    public boolean passesTest(Instance inst) throws Exception {
        if (inst.isMissing(this.m_AttIndex)) {
            return false;
        }
        boolean isNominal = inst.attribute(this.m_AttIndex).isNominal();
        double attribVal = inst.value(this.m_AttIndex);
        return !(!this.m_Not ? (isNominal ? (int)attribVal != (int)this.m_Split : attribVal >= this.m_Split) : (isNominal ? (int)attribVal == (int)this.m_Split : attribVal < this.m_Split));
    }

    public String toString() {
        return String.valueOf(this.m_Dataset.attribute(this.m_AttIndex).name()) + " " + this.testComparisonString();
    }

    public String toPrologString() {
        Attribute att = this.m_Dataset.attribute(this.m_AttIndex);
        StringBuffer str = new StringBuffer();
        String attName = this.m_Dataset.attribute(this.m_AttIndex).name();
        if (att.isNumeric()) {
            str = str.append(String.valueOf(attName) + " ");
            str = this.m_Not ? str.append(">= " + Utils.doubleToString(this.m_Split, 3)) : str.append("< " + Utils.doubleToString(this.m_Split, 3));
        } else {
            String value = att.value((int)this.m_Split);
            str = value == "false" ? str.append("not(" + attName + ")") : str.append(attName);
        }
        return str.toString();
    }

    private String testComparisonString() {
        Attribute att = this.m_Dataset.attribute(this.m_AttIndex);
        if (att.isNumeric()) {
            return String.valueOf(this.m_Not ? ">= " : "< ") + Utils.doubleToString(this.m_Split, 3);
        }
        if (att.numValues() != 2) {
            return String.valueOf(this.m_Not ? "!= " : "= ") + att.value((int)this.m_Split);
        }
        return "= " + (this.m_Not ? att.value((int)this.m_Split == 0 ? 1 : 0) : att.value((int)this.m_Split));
    }

    public boolean equalTo(Test t) {
        return this.m_AttIndex == t.m_AttIndex && this.m_Split == t.m_Split && this.m_Not == t.m_Not;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

