/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import weka.core.Utils;

public class LookAndFeel {
    public static String PROPERTY_FILE = "weka/gui/LookAndFeel.props";
    protected static Properties LOOKANDFEEL_PROPERTIES;

    static {
        try {
            LOOKANDFEEL_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "LookAndFeel: Could not read a LookAndFeel configuration file.\nAn example file is included in the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\"  and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "LookAndFeel", 0);
        }
    }

    public static boolean setLookAndFeel(String classname) {
        boolean result;
        try {
            UIManager.setLookAndFeel(classname);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static boolean setLookAndFeel() {
        String classname = LOOKANDFEEL_PROPERTIES.getProperty("Theme", "");
        if (classname.equals("")) {
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                return true;
            }
            classname = LookAndFeel.getSystemLookAndFeel();
        }
        return LookAndFeel.setLookAndFeel(classname);
    }

    public static String getSystemLookAndFeel() {
        return UIManager.getSystemLookAndFeelClassName();
    }

    public static String[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] laf = UIManager.getInstalledLookAndFeels();
        String[] result = new String[laf.length];
        int i = 0;
        while (i < laf.length) {
            result[i] = laf[i].getClassName();
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("\nInstalled Look and Feel themes:");
        String[] list = LookAndFeel.getInstalledLookAndFeels();
        int i = 0;
        while (i < list.length) {
            System.out.println(String.valueOf(i + 1) + ". " + list[i]);
            ++i;
        }
        System.out.println("\nNote: a theme can be set in '" + PROPERTY_FILE + "'.");
    }
}

