/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.StreamThroughput;
import weka.gui.beans.SubstringReplacerRules;
import weka.gui.beans.Visible;

@KFStep(category="Tools", toolTipText="Replace substrings in String attributes")
public class SubstringReplacer
extends JPanel
implements BeanCommon,
Visible,
Serializable,
InstanceListener,
EventConstraints,
EnvironmentHandler,
DataSource {
    private static final long serialVersionUID = 5636877747903965818L;
    protected transient Environment m_env;
    protected String m_matchReplaceDetails = "";
    protected transient SubstringReplacerRules m_mr;
    protected transient Logger m_log;
    protected transient boolean m_busy;
    protected Object m_listenee;
    protected ArrayList<InstanceListener> m_instanceListeners = new ArrayList();
    protected InstanceEvent m_ie = new InstanceEvent(this);
    protected BeanVisual m_visual = new BeanVisual("SubstringReplacer", "weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
    protected transient StreamThroughput m_throughput;

    public SubstringReplacer() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
    }

    public String globalInfo() {
        return "Replaces substrings in String attribute values using either literal match and replace or regular expression matching. The attributesto apply the match and replace rules to can be selected via a range string (e.g 1-5,6,last) or by a comma separated list of attribute names (/first and /last can be used to indicate the first and last attribute respectively)";
    }

    public void setMatchReplaceDetails(String details) {
        this.m_matchReplaceDetails = details;
    }

    public String getMatchReplaceDetails() {
        return this.m_matchReplaceDetails;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        if (!eventName.equals("instance")) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable(eventName);
    }

    @Override
    public synchronized void acceptInstance(InstanceEvent e) {
        this.m_busy = true;
        if (e.getStatus() == 0) {
            this.m_throughput = new StreamThroughput(this.statusMessagePrefix());
            Instances structure = e.getStructure();
            this.m_mr = new SubstringReplacerRules(this.m_matchReplaceDetails, structure, this.statusMessagePrefix(), this.m_log, this.m_env);
            if (!e.m_formatNotificationOnly && this.m_log != null) {
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "Processing stream...");
            }
            this.m_ie.setStructure(structure);
            this.m_ie.m_formatNotificationOnly = e.m_formatNotificationOnly;
            this.notifyInstanceListeners(this.m_ie);
        } else {
            Instance inst = e.getInstance();
            if (inst != null) {
                this.m_throughput.updateStart();
                this.m_mr.applyRules(inst);
                this.m_throughput.updateEnd(this.m_log);
            }
            this.m_ie.setInstance(inst);
            this.m_ie.setStatus(e.getStatus());
            this.notifyInstanceListeners(this.m_ie);
            if (e.getStatus() == 2 || inst == null) {
                this.m_throughput.finished(this.m_log);
            }
        }
        this.m_busy = false;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
        this.m_visual.setText("SubstringReplacer");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
        if (this.m_listenee != null && this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_log != null) {
            this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "Stopped");
        }
        this.m_busy = false;
    }

    @Override
    public boolean isBusy() {
        return this.m_busy;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        if (!eventName.equals("instance")) {
            return false;
        }
        return this.m_listenee == null;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        if (source == this.m_listenee) {
            this.m_listenee = null;
        }
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    protected String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInstanceListeners(InstanceEvent e) {
        List l;
        SubstringReplacer substringReplacer = this;
        synchronized (substringReplacer) {
            l = (List)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (InstanceListener il : l) {
                il.acceptInstance(e);
            }
        }
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.add(tsl);
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.remove(tsl);
    }

    @Override
    public void addDataSourceListener(DataSourceListener dsl) {
    }

    @Override
    public void removeDataSourceListener(DataSourceListener dsl) {
    }
}

