/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.Random;
import weka.core.Aggregateable;
import weka.core.Capabilities;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;

public class DiscreteEstimator
extends Estimator
implements IncrementalEstimator,
Aggregateable<DiscreteEstimator> {
    private static final long serialVersionUID = -5526486742612434779L;
    private final double[] m_Counts;
    private double m_SumOfCounts;
    private double m_FPrior;

    public DiscreteEstimator(int numSymbols, boolean laplace) {
        this.m_Counts = new double[numSymbols];
        this.m_SumOfCounts = 0.0;
        if (laplace) {
            this.m_FPrior = 1.0;
            int i = 0;
            while (i < numSymbols) {
                this.m_Counts[i] = 1.0;
                ++i;
            }
            this.m_SumOfCounts = numSymbols;
        }
    }

    public DiscreteEstimator(int nSymbols, double fPrior) {
        this.m_Counts = new double[nSymbols];
        this.m_FPrior = fPrior;
        int iSymbol = 0;
        while (iSymbol < nSymbols) {
            this.m_Counts[iSymbol] = fPrior;
            ++iSymbol;
        }
        this.m_SumOfCounts = fPrior * (double)nSymbols;
    }

    @Override
    public void addValue(double data, double weight) {
        int n = (int)data;
        this.m_Counts[n] = this.m_Counts[n] + weight;
        this.m_SumOfCounts += weight;
    }

    @Override
    public double getProbability(double data) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)data] / this.m_SumOfCounts;
    }

    public int getNumSymbols() {
        return this.m_Counts == null ? 0 : this.m_Counts.length;
    }

    public double getCount(double data) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)data];
    }

    public double getSumOfCounts() {
        return this.m_SumOfCounts;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Discrete Estimator. Counts = ");
        if (this.m_SumOfCounts > 1.0) {
            int i = 0;
            while (i < this.m_Counts.length) {
                result.append(" ").append(Utils.doubleToString(this.m_Counts[i], 2));
                ++i;
            }
            result.append("  (Total = ").append(Utils.doubleToString(this.m_SumOfCounts, 2));
            result.append(")\n");
        } else {
            int i = 0;
            while (i < this.m_Counts.length) {
                result.append(" ").append(this.m_Counts[i]);
                ++i;
            }
            result.append("  (Total = ").append(this.m_SumOfCounts).append(")\n");
        }
        return result.toString();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        if (!this.m_noClass) {
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        } else {
            result.enable(Capabilities.Capability.NO_CLASS);
        }
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9785 $");
    }

    @Override
    public DiscreteEstimator aggregate(DiscreteEstimator toAggregate) throws Exception {
        if (toAggregate.m_Counts.length != this.m_Counts.length) {
            throw new Exception("DiscreteEstimator to aggregate has a different number of symbols");
        }
        this.m_SumOfCounts += toAggregate.m_SumOfCounts;
        int i = 0;
        while (i < this.m_Counts.length) {
            int n = i;
            this.m_Counts[n] = this.m_Counts[n] + (toAggregate.m_Counts[i] - toAggregate.m_FPrior);
            ++i;
        }
        this.m_SumOfCounts -= toAggregate.m_FPrior * (double)this.m_Counts.length;
        return this;
    }

    @Override
    public void finalizeAggregation() throws Exception {
    }

    protected static void testAggregation() {
        DiscreteEstimator df = new DiscreteEstimator(5, true);
        DiscreteEstimator one = new DiscreteEstimator(5, true);
        DiscreteEstimator two = new DiscreteEstimator(5, true);
        Random r = new Random(1L);
        int i = 0;
        while (i < 100) {
            int z = Math.abs(r.nextInt()) % 5;
            df.addValue(z, 1.0);
            if (i < 50) {
                one.addValue(z, 1.0);
            } else {
                two.addValue(z, 1.0);
            }
            ++i;
        }
        try {
            System.out.println("\n\nFull\n");
            System.out.println(df.toString());
            System.out.println("Prob (0): " + df.getProbability(0.0));
            System.out.println("\nOne\n" + one.toString());
            System.out.println("Prob (0): " + one.getProbability(0.0));
            System.out.println("\nTwo\n" + two.toString());
            System.out.println("Prob (0): " + two.getProbability(0.0));
            one = one.aggregate(two);
            System.out.println("\nAggregated\n");
            System.out.println(one.toString());
            System.out.println("Prob (0): " + one.getProbability(0.0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        try {
            int current;
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int max = current = Integer.parseInt(argv[0]);
            int i = 1;
            while (i < argv.length) {
                current = Integer.parseInt(argv[i]);
                if (current > max) {
                    max = current;
                }
                ++i;
            }
            DiscreteEstimator newEst = new DiscreteEstimator(max + 1, true);
            int i2 = 0;
            while (i2 < argv.length) {
                current = Integer.parseInt(argv[i2]);
                System.out.println(newEst);
                System.out.println("Prediction for " + current + " = " + newEst.getProbability(current));
                newEst.addValue(current, 1.0);
                ++i2;
            }
            DiscreteEstimator.testAggregation();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

