/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.epsilon.emc.emf.CachedResourceSet;
import org.eclipse.epsilon.emc.emf.ContainmentChangeAdapter;
import org.eclipse.epsilon.emc.emf.EmfPropertyGetter;
import org.eclipse.epsilon.emc.emf.EmfPropertySetter;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.emc.emf.transactions.EmfModelTransactionSupport;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.transactions.IModelTransactionSupport;

public abstract class AbstractEmfModel
extends CachedModel<EObject> {
    protected Resource modelImpl;
    protected boolean expand = true;
    Map<String, EClass> eClassCache = new HashMap<String, EClass>();
    protected EPackage.Registry registry = null;
    protected EmfModelTransactionSupport transactionSupport;

    protected InputStream getInputStream(String file) throws IOException {
        if (file.startsWith("bundleresource:") || file.startsWith("platform:")) {
            URL url = new URL(file);
            return url.openConnection().getInputStream();
        }
        return new FileInputStream(file);
    }

    protected void setDataTypesInstanceClasses(Resource metamodel) {
        TreeIterator<EObject> it = metamodel.getAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (eObject instanceof EEnum || !(eObject instanceof EDataType)) continue;
            EDataType eDataType = (EDataType)eObject;
            String instanceClass = "";
            if (eDataType.getName().equals("String")) {
                instanceClass = "java.lang.String";
            } else if (eDataType.getName().equals("Boolean")) {
                instanceClass = "java.lang.Boolean";
            } else if (eDataType.getName().equals("Integer")) {
                instanceClass = "java.lang.Integer";
            } else if (eDataType.getName().equals("Float")) {
                instanceClass = "java.lang.Float";
            } else if (eDataType.getName().equals("Double")) {
                instanceClass = "java.lang.Double";
            }
            eDataType.setInstanceClassName(instanceClass);
        }
    }

    public void addMetamodelUri(String nsUri) {
        this.getPackageRegistry().put(nsUri, EPackage.Registry.INSTANCE.get(nsUri));
    }

    protected EPackage.Registry getPackageRegistry() {
        if (this.registry == null) {
            this.registry = this.modelImpl.getResourceSet() == null ? EPackage.Registry.INSTANCE : this.modelImpl.getResourceSet().getPackageRegistry();
        }
        return this.registry;
    }

    @Override
    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        for (Object pkg : this.getPackageRegistry().values()) {
            if (!(pkg instanceof EPackage)) continue;
            EPackage ePackage = null;
            ePackage = (EPackage)pkg;
            for (EClassifier classifier : EmfUtil.getAllEClassifiers(ePackage)) {
                EEnum eEnum;
                EEnumLiteral literal;
                if (!(classifier instanceof EEnum) || !((EEnum)classifier).getName().equals(enumeration) && !this.getFullyQualifiedName(classifier).equals(enumeration) || (literal = (eEnum = (EEnum)classifier).getEEnumLiteral(label)) == null) continue;
                return literal.getInstance();
            }
        }
        throw new EolEnumerationValueNotFoundException(enumeration, label, this.getName());
    }

    @Override
    public boolean knowsAboutProperty(Object instance, String property) {
        if (!this.owns(instance)) {
            return false;
        }
        EObject eObject = (EObject)instance;
        return this.knowsAboutProperty(eObject, property);
    }

    protected boolean knowsAboutProperty(EObject instance, String property) {
        return EmfUtil.getEStructuralFeature(instance.eClass(), property) != null;
    }

    @Override
    protected Collection<EObject> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(type);
        ArrayList<EObject> allOfType = new ArrayList<EObject>();
        for (EObject eObject : this.allContents()) {
            if (eObject.eClass() != eClass) continue;
            allOfType.add(eObject);
        }
        return allOfType;
    }

    @Override
    public Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return this.classForName(type);
    }

    public EClass classForName(String name) throws EolModelElementTypeNotFoundException {
        if (name != null) {
            if (this.eClassCache.containsKey(name)) {
                return this.eClassCache.get(name);
            }
            EClass eClass = this.classForName(name, this.getPackageRegistry());
            if (eClass != null) {
                this.eClassCache.put(name, eClass);
                return eClass;
            }
        }
        throw new EolModelElementTypeNotFoundException(this.name, name);
    }

    protected EClass classForName(String name, EPackage.Registry registry) {
        boolean absolute = name.indexOf("::") > -1;
        for (Object pkg : registry.values()) {
            EClass eClass;
            if (!(pkg instanceof EPackage) || (eClass = this.classForName(name, absolute, pkg)) == null) continue;
            return eClass;
        }
        return null;
    }

    private EClass classForName(String name, boolean absolute, Object pkg) {
        for (EClassifier eClassifier : EmfUtil.getAllEClassifiers((EPackage)pkg)) {
            if (!(eClassifier instanceof EClass)) continue;
            String eClassifierName = "";
            eClassifierName = absolute ? this.getFullyQualifiedName(eClassifier) : eClassifier.getName();
            if (eClassifierName.compareTo(name) != 0) continue;
            return (EClass)eClassifier;
        }
        return null;
    }

    @Override
    protected Collection<EObject> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(kind);
        ArrayList<EObject> allOfKind = new ArrayList<EObject>();
        for (EObject eObject : this.allContents()) {
            if (!eClass.isInstance(eObject)) continue;
            allOfKind.add(eObject);
        }
        return allOfKind;
    }

    @Override
    protected Collection<EObject> allContentsFromModel() {
        ArrayList<EObject> allInstances = new ArrayList<EObject>();
        for (Resource resource : this.getResources()) {
            TreeIterator<EObject> it = resource.getAllContents();
            while (it.hasNext()) {
                allInstances.add((EObject)it.next());
            }
        }
        return allInstances;
    }

    @Override
    protected EObject createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        EClass eClass = this.classForName(type);
        if (eClass.isAbstract()) {
            throw new EolNotInstantiableModelElementTypeException(this.name, type);
        }
        EObject instance = eClass.getEPackage().getEFactoryInstance().create(eClass);
        this.modelImpl.getContents().add(instance);
        instance.eAdapters().add(new ContainmentChangeAdapter(instance, this.modelImpl));
        return instance;
    }

    @Override
    public IModelTransactionSupport getTransactionSupport() {
        if (this.transactionSupport == null) {
            this.transactionSupport = new EmfModelTransactionSupport(this);
        }
        return this.transactionSupport;
    }

    protected int instancesCount(Resource r) {
        int i = 0;
        TreeIterator<EObject> ite = r.getAllContents();
        while (ite.hasNext()) {
            ite.next();
            ++i;
        }
        return i;
    }

    @Override
    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        if (!(instance instanceof EObject)) {
            return false;
        }
        EObject eObject = (EObject)instance;
        EcoreUtil.delete(eObject);
        ArrayList<EObject> contents = new ArrayList<EObject>();
        TreeIterator<EObject> contentsIterator = eObject.eAllContents();
        while (contentsIterator.hasNext()) {
            contents.add((EObject)contentsIterator.next());
        }
        for (EObject content : contents) {
            this.deleteElement(content);
        }
        contents.clear();
        return true;
    }

    @Override
    public boolean owns(Object instance) {
        if (instance instanceof EObject) {
            EObject eObject = (EObject)instance;
            Resource eObjectResource = eObject.eResource();
            if (eObjectResource == null) {
                return false;
            }
            if (this.expand) {
                return this.modelImpl.getResourceSet() == eObjectResource.getResourceSet();
            }
            return this.modelImpl == eObjectResource;
        }
        return false;
    }

    @Override
    public boolean store(String fileName) {
        return this.store(EmfUtil.createPlatformResourceURI(fileName));
    }

    public boolean store(URI uri) {
        URI oldUri = this.modelImpl.getURI();
        try {
            try {
                this.modelImpl.setURI(uri);
                this.modelImpl.save(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.modelImpl.setURI(oldUri);
                return false;
            }
        }
        finally {
            this.modelImpl.setURI(oldUri);
        }
        return true;
    }

    public boolean store(OutputStream os) {
        if (this.modelImpl == null) {
            return false;
        }
        try {
            this.modelImpl.save(os, null);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void disposeModel() {
        this.registry = null;
        if (this.modelImpl != null) {
            CachedResourceSet.getCache().returnResource(this.modelImpl);
            this.modelImpl = null;
        }
        this.eClassCache.clear();
    }

    public Resource getResource() {
        return this.modelImpl;
    }

    public void setResource(Resource resource) {
        this.modelImpl = resource;
    }

    public Resource getModelImpl() {
        return this.modelImpl;
    }

    public void setModelImpl(Resource modelImpl) {
        this.modelImpl = modelImpl;
    }

    protected List<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.expand && this.modelImpl.getResourceSet() != null) {
            resources.addAll(this.modelImpl.getResourceSet().getResources());
        } else {
            resources.add(this.modelImpl);
        }
        return resources;
    }

    @Override
    public Object getElementById(String id) {
        for (Resource resource : this.getResources()) {
            EObject instance = resource.getEObject(id);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    @Override
    public String getElementId(Object instance) {
        EObject eObject = (EObject)instance;
        return eObject.eResource().getURIFragment(eObject);
    }

    @Override
    public void setElementId(Object instance, String newId) {
        if (newId == null || newId.isEmpty()) {
            return;
        }
        if (this.isUriFragment(newId)) {
            return;
        }
        EObject eObject = (EObject)instance;
        if (eObject.eResource() instanceof XMIResource) {
            ((XMIResource)eObject.eResource()).setID(eObject, newId);
        }
    }

    private boolean isUriFragment(String newId) {
        return newId.startsWith("/") || newId.startsWith("#/");
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        return new EmfPropertyGetter();
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return new EmfPropertySetter();
    }

    @Override
    public Object getTypeOf(Object instance) {
        return ((EObject)instance).eClass();
    }

    @Override
    public String getTypeNameOf(Object instance) {
        if (!this.isModelElement(instance)) {
            throw new IllegalArgumentException("Not a valid EMF model element: " + instance + " (" + instance.getClass().getCanonicalName() + ") ");
        }
        return ((EClass)this.getTypeOf(instance)).getName();
    }

    @Override
    public String getFullyQualifiedTypeNameOf(Object instance) {
        if (!this.isModelElement(instance)) {
            throw new IllegalArgumentException("Not a valid EMF model element: " + instance + " (" + instance.getClass().getCanonicalName() + ") ");
        }
        return this.getFullyQualifiedName((EClass)this.getTypeOf(instance));
    }

    @Override
    public Collection<String> getAllTypeNamesOf(Object instance) {
        ArrayList<String> allTypeNames = new ArrayList<String>();
        if (this.isModelElement(instance)) {
            EClass type = (EClass)this.getTypeOf(instance);
            allTypeNames.add(type.getName());
            for (EClass supertype : type.getEAllSuperTypes()) {
                allTypeNames.add(supertype.getName());
            }
        }
        return allTypeNames;
    }

    @Override
    public boolean isInstantiable(String type) {
        try {
            return !this.classForName(type).isAbstract();
        }
        catch (EolModelElementTypeNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean hasType(String type) {
        block3: {
            try {
                if (!this.eClassCache.containsKey(type)) break block3;
                return true;
            }
            catch (EolModelElementTypeNotFoundException e) {
                return false;
            }
        }
        this.classForName(type);
        return true;
    }

    protected String getFullyQualifiedName(EClassifier eClassifier) {
        String fullyQualifiedName = eClassifier.getName();
        EPackage parent = eClassifier.getEPackage();
        while (parent != null) {
            fullyQualifiedName = String.valueOf(parent.getName()) + "::" + fullyQualifiedName;
            parent = parent.getESuperPackage();
        }
        return fullyQualifiedName;
    }

    @Override
    public boolean isModelElement(Object instance) {
        return instance instanceof EObject;
    }

    public boolean isExpand() {
        return this.expand;
    }

    @Override
    public boolean isOfKind(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(metaClass);
        return eClass.isInstance(instance);
    }

    @Override
    public boolean isOfType(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(metaClass);
        if (instance instanceof EObject) {
            EObject eObject = (EObject)instance;
            return eClass == eObject.eClass();
        }
        return false;
    }

    public Object getContainerOf(Object object) {
        if (object instanceof EObject) {
            return ((EObject)object).eContainer();
        }
        return null;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }
}

