/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.emc.wrappers;

import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.flock.context.ConservativeCopyContext;
import org.eclipse.epsilon.flock.emc.wrappers.BackedModelValue;
import org.eclipse.epsilon.flock.emc.wrappers.Model;
import org.eclipse.epsilon.flock.emc.wrappers.ModelType;
import org.eclipse.epsilon.flock.emc.wrappers.ModelValue;

public class ModelElement
extends BackedModelValue<Object> {
    private final ModelType type;

    static ModelElement create(Model model, Object object) {
        if (!model.isModelElement(object)) {
            throw new IllegalArgumentException("Object is not an element of this model: " + object);
        }
        ModelType type = new ModelType(model, model.getTypeNameOf(object), model.getUnqualifiedTypeNameOf(object));
        return new ModelElement(model, type, object);
    }

    ModelElement(Model model, ModelType type, Object underlyingModelElement) {
        super(model, underlyingModelElement);
        this.type = type;
    }

    @Override
    public ModelValue<?> getEquivalentIn(Model model, ConservativeCopyContext context) {
        return this.isExternal() ? this : model.wrap(context.getEquivalent(this));
    }

    private boolean isExternal() {
        return !this.model.owns(this.underlyingModelObject);
    }

    public Model getModel() {
        return this.model;
    }

    public ModelType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public String getUnqualifiedTypeName() {
        return this.type.getUnqualifiedName();
    }

    public boolean isTypeOf(String type) {
        return this.model.isTypeOf(this.underlyingModelObject, type);
    }

    public boolean isKindOf(String type) {
        return this.model.isKindOf(this.underlyingModelObject, type);
    }

    public boolean belongsTo(String originalPackage) {
        List<String> packages = this.model.getPackageNamesOf(this.underlyingModelObject);
        return !packages.isEmpty() && packages.get(0).equals(originalPackage);
    }

    public ModelElement getContainer() {
        Object container = this.model.getContainerOf(this.underlyingModelObject);
        return container == null ? null : ModelElement.create(this.model, container);
    }

    public void copyIdentityFrom(ModelElement original) {
        this.setIdentity(original.getIdentity());
    }

    String getIdentity() {
        return this.model.getIdentity(this.underlyingModelObject);
    }

    void setIdentity(String identity) {
        this.model.setIdentity(this.underlyingModelObject, identity);
    }

    public Collection<String> getPropertiesSharedWith(ModelElement element) throws EolModelElementTypeNotFoundException {
        return this.type.getPropertiesSharedWith(element.getType());
    }

    public ModelValue<?> getValueOfProperty(String property) throws EolRuntimeException {
        return this.model.getValueOfProperty(this.underlyingModelObject, property);
    }

    public void conservativelySetValueForProperty(ModelValue<?> equivalentValue, String propertyName, ConservativeCopyContext context) throws EolRuntimeException {
        if (this.conforms(propertyName, equivalentValue)) {
            this.setValueOfProperty(propertyName, equivalentValue);
        }
    }

    private boolean conforms(String property, ModelValue<?> value) throws EolRuntimeException {
        return this.model.conforms(this.underlyingModelObject, property, value);
    }

    private void setValueOfProperty(String property, ModelValue<?> value) throws EolRuntimeException {
        try {
            this.model.setValueOfProperty(this.underlyingModelObject, property, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "<" + this.model.getStringRepresentationOf(this.underlyingModelObject) + ">";
    }
}

