/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.exceptions;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class EglRuntimeException
extends EolRuntimeException {
    private static final long serialVersionUID = 2370066735399525557L;
    private final Throwable cause;
    private final int line;
    private final int column;

    public EglRuntimeException(EolRuntimeException ex) {
        super(ex.getReason(), ex.getAst());
        this.reason = ex.getReason();
        this.cause = ex;
        this.line = ex.getAst().getLine();
        this.column = ex.getColumn();
        this.ast = ex.getAst();
    }

    public EglRuntimeException(EolInternalException ex) {
        super(ex.getReason(), ex.getAst());
        EglRuntimeException internal = (EglRuntimeException)ex.getInternal();
        this.reason = internal.getReason();
        this.cause = internal.getCause();
        this.line = ex.getAst().getLine();
        this.column = ex.getColumn();
        this.ast = ex.getAst();
    }

    public EglRuntimeException(String reason, AST ast) {
        this(reason, null, ast);
    }

    public EglRuntimeException(String reason, Throwable cause) {
        this(reason, cause, 1, 1, null);
    }

    public EglRuntimeException(String reason, Throwable cause, AST ast) {
        this(reason, cause, ast.getLine(), ast.getColumn(), ast);
    }

    private EglRuntimeException(String reason, Throwable cause, int line, int column, AST ast) {
        this.reason = reason;
        this.cause = cause;
        this.line = line;
        this.column = column;
        this.ast = ast;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.cause != null) {
            result = String.valueOf(result) + "\n\tCause: " + this.cause.toString();
        }
        return result;
    }
}

