/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonTreeAdaptor;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.UriUtil;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.internal.EglPreprocessorModule;
import org.eclipse.epsilon.egl.internal.EglResult;
import org.eclipse.epsilon.egl.internal.IEglModule;
import org.eclipse.epsilon.egl.model.EglMarkerSection;
import org.eclipse.epsilon.egl.model.EglSection;
import org.eclipse.epsilon.egl.parse.EglLexer;
import org.eclipse.epsilon.egl.parse.EglParser;
import org.eclipse.epsilon.eol.EolLibraryModule;
import org.eclipse.epsilon.eol.EolOperations;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EglModule
extends EolLibraryModule
implements IEglModule {
    protected EglParser parser = null;
    protected EglLexer lexer = null;
    protected IEglContext context = null;
    protected Reader reader;
    protected EglPreprocessorModule preprocessorModule = null;
    private final List<EglSection> sections = new LinkedList<EglSection>();
    private URI templateRoot;

    public EglModule() {
        this.reset();
    }

    public EglModule(IEglContext context) {
        this.context = context;
        this.reset();
    }

    @Override
    public boolean parse(String code) throws Exception {
        return this.parse(code, null);
    }

    @Override
    public boolean parse(String code, File file) throws Exception {
        return this.parseFromLexer(new EglLexer(code), file);
    }

    @Override
    public boolean parse(File file) throws Exception {
        return this.parse(file.toURI());
    }

    private boolean parseFromLexer(EglLexer lexer, File file) throws Exception {
        this.sourceFile = file;
        if (file != null) {
            this.sourceUri = file.toURI();
            try {
                this.templateRoot = UriUtil.fileToUri(file.getParentFile());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return this.parseAndPreprocess(lexer, file);
    }

    @Override
    public boolean parse(URI uri) throws Exception {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        try {
            this.sourceUri = uri;
            this.templateRoot = uri;
            if (uri.getScheme() != null && uri.getScheme().equals("file")) {
                this.sourceFile = new File(uri);
            }
            this.reader = new BufferedReader(new InputStreamReader(uri.toURL().openStream()));
            boolean bl = this.parseAndPreprocess(new EglLexer(this.reader), this.sourceFile);
            return bl;
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private boolean parseAndPreprocess(EglLexer lexer, File file) throws Exception {
        this.lexer = lexer;
        EpsilonTreeAdaptor astFactory = new EpsilonTreeAdaptor(file, (IModule)this);
        this.parser = new EglParser(lexer, astFactory);
        this.parser.parse();
        this.ast = this.parser.getAST();
        boolean validEgl = this.parser.getParseProblems().size() == 0;
        boolean validEol = this.preprocess();
        if (validEgl && validEol) {
            this.buildModel();
        }
        return validEgl && validEol;
    }

    private boolean preprocess() {
        return this.preprocessorModule.preprocess(this.ast, this.sourceFile, this.sourceUri);
    }

    @Override
    public void buildModel() throws Exception {
        for (AST child : this.ast.getChildren()) {
            EglSection section = EglSection.createFrom(child);
            if (section == null || !(section instanceof EglMarkerSection)) continue;
            this.sections.add(section);
        }
    }

    @Override
    public EglResult execute(EglTemplate template, Formatter postprocessor) throws EglRuntimeException {
        this.context.enter(template);
        String generatedText = this.execute(postprocessor);
        this.context.exit();
        return new EglResult(generatedText);
    }

    private String execute(Formatter postprocessor) throws EglRuntimeException {
        this.context.setModule(this);
        this.context.getTemplateFactory().initialiseRoot(this.templateRoot);
        this.context.copyInto(this.preprocessorModule.getContext());
        this.preprocessorModule.execute();
        this.context.formatWith(postprocessor);
        this.checkOutput();
        return this.context.getOutputBuffer().toString();
    }

    private void checkOutput() throws EglRuntimeException {
        List<String> problems = this.context.getPartitioningProblems();
        if (problems.size() > 0) {
            throw new EglRuntimeException(problems.get(0), this.ast);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.preprocessorModule = new EglPreprocessorModule();
    }

    @Override
    public IEglContext getContext() {
        return this.context;
    }

    @Override
    public List<ParseProblem> getParseProblems() {
        ArrayList<ParseProblem> combinedErrors = new ArrayList<ParseProblem>(this.parser.getParseProblems());
        combinedErrors.addAll(this.preprocessorModule.getParseProblems());
        return combinedErrors;
    }

    @Override
    public EolOperations getOperations() {
        return this.preprocessorModule.getOperations();
    }

    @Override
    public AST getAst() {
        return this.preprocessorModule.getAst();
    }

    @Override
    public List<ModuleElement> getChildren() {
        LinkedList<ModuleElement> children = new LinkedList<ModuleElement>();
        children.addAll(this.preprocessorModule.getImports());
        children.addAll(this.sections);
        children.addAll(this.preprocessorModule.getDeclaredOperations());
        return children;
    }

    @Override
    public void setContext(IEolContext context) {
        if (context instanceof IEglContext) {
            this.context = (IEglContext)context;
        }
    }
}

