/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.IEolLibraryModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.tools.AbstractTool;
import org.eclipse.epsilon.eol.types.EolNoType;

public class SchedulerTool
extends AbstractTool {
    ArrayList<Job> jobs = new ArrayList();
    ArrayList<EolOperation> queque = new ArrayList();

    public void schedule(String operationName, int period) throws EolRuntimeException {
        this.schedule(operationName, period, -1);
    }

    public void schedule(String operationName, int period, int times) throws EolRuntimeException {
        this.addJob(operationName, period, times);
        this.start();
    }

    public void addJob(String operationName, int period) throws EolRuntimeException {
        this.addJob(operationName, period, -1);
    }

    public void addJob(String operationName, int period, int times) throws EolRuntimeException {
        Job job = new Job(operationName, this.context, period, times);
        this.jobs.add(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws EolRuntimeException {
        for (Job job : this.jobs) {
            job.start();
        }
        boolean finished = true;
        while (true) {
            finished = true;
            for (Job job : this.jobs) {
                boolean bl = finished = finished && job.finished;
            }
            if (finished) {
                return;
            }
            ArrayList<EolOperation> arrayList = this.queque;
            synchronized (arrayList) {
                EolOperation operation;
                if (this.queque.size() > 0 && (operation = this.queque.remove(0)) != null) {
                    operation.execute(EolNoType.NoInstance, Collections.emptyList(), this.context);
                }
            }
        }
    }

    public void start(int time) throws EolRuntimeException {
        for (Job job : this.jobs) {
            job.times = (int)Math.ceil(time / job.period);
        }
        this.start();
    }

    class Job {
        Timer timer = new Timer(false);
        JobTask jobTask;
        int timesExecuted = 0;
        boolean finished = false;
        EolRuntimeException exception = null;
        int times = 0;
        int period = 0;

        public Job(String operationName, IEolContext context, int period, int times) throws EolRuntimeException {
            this.times = times;
            this.period = period;
            this.jobTask = new JobTask(SchedulerTool.this, operationName, context, period){

                @Override
                public void run() {
                    if (Job.this.timesExecuted < Job.this.times || Job.this.times == -1) {
                        ((Job)Job.this).SchedulerTool.this.queque.add(0, this.operation);
                        ++Job.this.timesExecuted;
                    } else {
                        Job.this.finished = true;
                        Job.this.timer.cancel();
                    }
                }
            };
        }

        public void start() {
            this.timer.schedule((TimerTask)this.jobTask, 0L, (long)this.jobTask.period);
        }
    }

    abstract class JobTask
    extends TimerTask {
        int period = 0;
        EolOperation operation = null;

        public JobTask(String operationName, IEolContext context, int period) throws EolRuntimeException {
            this.period = period;
            this.operation = ((IEolLibraryModule)context.getModule()).getOperations().getOperation(operationName);
            if (this.operation == null) {
                throw new EolRuntimeException("Operation " + operationName + " not found");
            }
        }
    }
}

