/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl.trace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.ecl.MatchRule;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class MatchTrace {
    protected List<Match> matches = new ArrayList<Match>();

    public MatchTrace getReduced() {
        MatchTrace reduced = new MatchTrace();
        for (Match match : this.matches) {
            if (!match.isMatching()) continue;
            reduced.getMatches().add(match);
        }
        return reduced;
    }

    public MatchTrace() {
    }

    public MatchTrace(MatchTrace copy) {
        this.getMatches().addAll(copy.getMatches());
    }

    public Match add(Object left, Object right, boolean matching, MatchRule rule) {
        Match match = this.createMatch(left, right, matching);
        match.setRule(rule);
        this.getMatches().add(match);
        return match;
    }

    public Match getMatch(Object left, Object right) {
        for (Match match : this.getMatches()) {
            if (!match.contains(left, right)) continue;
            return match;
        }
        return null;
    }

    public List<Match> getMatches(Object object) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Match match : this.getMatches()) {
            if (!match.contains(object) || !match.isMatching()) continue;
            matches.add(match);
        }
        return matches;
    }

    public Match getMatch(Object object) {
        for (Match match : this.getMatches()) {
            if (!match.contains(object) || !match.isMatching()) continue;
            return match;
        }
        return null;
    }

    public Match getMatch(Object left, MatchRule rule) {
        for (Match match : this.getMatches()) {
            if (!match.isMatching() || match.left != left || match.getRule() != rule) continue;
            return match;
        }
        return null;
    }

    public boolean hasBeenMatched(Object object) {
        for (Match match : this.getMatches()) {
            if (!match.contains(object)) continue;
            return true;
        }
        return false;
    }

    public Match createMatch(Object left, Object right, boolean matching) {
        return new Match(left, right, matching);
    }

    public String toString(IEolContext context) {
        String str = "";
        for (Match match : this.getMatches()) {
            str = String.valueOf(str) + "[" + match.isMatching() + "]\n";
            str = String.valueOf(str) + context.getPrettyPrinterManager().toString(match.getLeft());
            str = String.valueOf(str) + "\n ->" + context.getPrettyPrinterManager().toString(match.getRight());
        }
        str = String.valueOf(str) + "-------------------------------------------";
        return str;
    }

    public List<Match> getMatches() {
        return this.matches;
    }
}

