/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.egl.EglPersistentTemplate;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.EgxModule;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.eol.EolFormalParameter;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.erl.rules.NamedRule;

public class GenerationRule
extends NamedRule
implements ModuleElement {
    protected EolFormalParameter sourceParameter = null;
    protected AST targetAst = null;
    protected AST guardAst = null;
    protected AST templateAst = null;
    protected AST parametersAst = null;
    protected AST preAst = null;
    protected AST postAst = null;
    protected AST overwriteAst = null;
    protected AST protectRegionsAst = null;
    protected Boolean isGreedy;

    public GenerationRule(AST ast) {
        this.parse(ast);
    }

    protected void parse(AST ast) {
        this.ast = ast;
        this.name = ast.getFirstChild().getText();
        AST sourceParameterAst = ast.getFirstChild().getNextSibling();
        if (sourceParameterAst != null && sourceParameterAst.getType() == 24) {
            this.sourceParameter = new EolFormalParameter(sourceParameterAst);
        }
        this.templateAst = AstUtil.getChild(ast, 82);
        this.guardAst = AstUtil.getChild(ast, 79);
        this.targetAst = AstUtil.getChild(ast, 81);
        this.parametersAst = AstUtil.getChild(ast, 46);
        this.preAst = AstUtil.getChild(ast, 76);
        this.postAst = AstUtil.getChild(ast, 77);
        this.overwriteAst = AstUtil.getChild(ast, 83);
        this.protectRegionsAst = AstUtil.getChild(ast, 84);
    }

    public boolean isGreedy() throws EolRuntimeException {
        if (this.isGreedy == null) {
            this.isGreedy = EolAnnotationsUtil.getBooleanAnnotationValue(this.ast, "greedy", null);
        }
        return this.isGreedy;
    }

    public void generateAll(IEglContext context, EglTemplateFactory templateFactory, EgxModule module) throws EolRuntimeException {
        Collection<Object> all = new ArrayList();
        if (this.sourceParameter != null) {
            EolType sourceParameterType = this.sourceParameter.getType(context);
            if (sourceParameterType instanceof EolModelElementType) {
                all = this.isGreedy() ? ((EolModelElementType)sourceParameterType).getAllOfKind() : ((EolModelElementType)sourceParameterType).getAllOfType();
            }
        } else {
            all.add(null);
        }
        HashMap<URI, EglTemplate> templateCache = new HashMap<URI, EglTemplate>();
        for (Object o : all) {
            URI templateUri;
            if (this.sourceParameter != null) {
                context.getFrameStack().enterLocal(FrameType.PROTECTED, this.getAst(), Variable.createReadOnlyVariable(this.sourceParameter.getName(), o));
            } else {
                context.getFrameStack().enterLocal(FrameType.PROTECTED, this.getAst(), new Variable[0]);
            }
            if (this.preAst != null) {
                context.getExecutorFactory().executeAST(this.preAst.getFirstChild(), context);
            }
            boolean guard = true;
            if (this.guardAst != null) {
                Return r = (Return)context.getExecutorFactory().executeBlockOrExpressionAst(this.guardAst.getFirstChild(), context);
                Object value = r.getValue();
                if (!(value instanceof Boolean)) {
                    throw new EolIllegalReturnException("Boolean", value, this.guardAst, context);
                }
                guard = (Boolean)value;
            }
            if (!guard) continue;
            boolean overwrite = true;
            if (this.overwriteAst != null) {
                Return r = (Return)context.getExecutorFactory().executeBlockOrExpressionAst(this.overwriteAst.getFirstChild(), context);
                Object value = r.getValue();
                if (!(value instanceof Boolean)) {
                    throw new EolIllegalReturnException("Boolean", value, this.overwriteAst, context);
                }
                overwrite = (Boolean)value;
            }
            boolean protectRegions = true;
            if (this.protectRegionsAst != null) {
                Return r = (Return)context.getExecutorFactory().executeBlockOrExpressionAst(this.protectRegionsAst.getFirstChild(), context);
                Object value = r.getValue();
                if (!(value instanceof Boolean)) {
                    throw new EolIllegalReturnException("Boolean", value, this.protectRegionsAst, context);
                }
                protectRegions = (Boolean)value;
            }
            EolMap parameters = new EolMap();
            if (this.parametersAst != null) {
                Return r = (Return)context.getExecutorFactory().executeBlockOrExpressionAst(this.parametersAst.getFirstChild(), context);
                Object value = r.getValue();
                if (!(value instanceof EolMap)) {
                    throw new EolIllegalReturnException("Map", value, this.parametersAst, context);
                }
                parameters = (EolMap)value;
            }
            String template = null;
            if (this.templateAst != null) {
                Return r = (Return)context.getExecutorFactory().executeBlockOrExpressionAst(this.templateAst.getFirstChild(), context);
                template = "" + r.getValue();
            }
            String target = null;
            if (this.targetAst != null) {
                Return r = (Return)context.getExecutorFactory().executeBlockOrExpressionAst(this.targetAst.getFirstChild(), context);
                target = "" + r.getValue();
            }
            if (!templateCache.containsKey(templateUri = templateFactory.resolveTemplate(template))) {
                templateCache.put(templateUri, templateFactory.load(templateUri));
            }
            EglTemplate eglTemplate = (EglTemplate)templateCache.get(templateUri);
            if (this.sourceParameter != null) {
                eglTemplate.populate(this.sourceParameter.getName(), o);
            }
            for (Object key : parameters.keySet()) {
                eglTemplate.populate("" + key, parameters.get(key));
            }
            if (eglTemplate instanceof EglPersistentTemplate) {
                ((EglPersistentTemplate)eglTemplate).generate(target, overwrite, protectRegions);
            }
            module.getInvokedTemplates().add(eglTemplate.getTemplate());
            if (this.postAst != null) {
                context.getExecutorFactory().executeAST(this.postAst.getFirstChild(), context);
            }
            context.getFrameStack().leaveLocal(this.getAst());
            eglTemplate.reset();
        }
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        String label = this.name;
        if (this.sourceParameter != null) {
            label = String.valueOf(label) + " (" + this.sourceParameter.getTypeName() + ")";
        }
        return label;
    }
}

