/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.engine.traceability.fine.internal;

import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.egl.engine.traceability.fine.internal.TracedPropertyAccessLedger;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.Region;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.internal.EglPreprocessorContext;
import org.eclipse.epsilon.egl.output.OutputBuffer;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;
import org.eclipse.epsilon.eol.execute.introspection.recording.IPropertyAccess;
import org.eclipse.epsilon.eol.execute.introspection.recording.IPropertyAccessRecorder;

public class EglOutputBufferPrintExecutionListener
implements IExecutionListener {
    private final IPropertyAccessRecorder recorder;
    private final WeakHashMap<AST, TraceData> cache = new WeakHashMap();
    private final TracedPropertyAccessLedger ledger;

    public EglOutputBufferPrintExecutionListener(IPropertyAccessRecorder recorder, TracedPropertyAccessLedger ledger) {
        this.recorder = recorder;
        this.ledger = ledger;
    }

    @Override
    public void finishedExecuting(AST ast, Object result, IEolContext context) {
        if (result instanceof OutputBuffer && this.isCallToPrintMethod(ast.getParent())) {
            OutputBuffer buffer = (OutputBuffer)result;
            this.cache.put(ast.getParent(), new TraceData(buffer, buffer.getOffset()));
            this.recorder.startRecording();
        }
        if (this.cache.containsKey(ast)) {
            this.recorder.stopRecording();
            this.associatePropertyAccessesWithRegionInGeneratedText(ast, ((EglPreprocessorContext)context).getEglContext());
        }
    }

    protected boolean isCallToPrintMethod(AST p) {
        List<String> printMethods = Arrays.asList("printdyn", "println", "print", "prinx");
        return p.getType() == 9 && printMethods.contains(p.getSecondChild().getText());
    }

    private void associatePropertyAccessesWithRegionInGeneratedText(AST ast, IEglContext context) {
        Region region = this.regionFor(ast);
        for (IPropertyAccess iPropertyAccess : this.recorder.getPropertyAccesses().all()) {
            this.ledger.associate(iPropertyAccess, region, context.getCurrentTemplate());
        }
    }

    private Region regionFor(AST ast) {
        int offset = this.cache.get((Object)ast).offset;
        int length = this.cache.get((Object)ast).buffer.getOffset() - offset;
        Region region = new Region(offset, length);
        return region;
    }

    @Override
    public void aboutToExecute(AST ast, IEolContext context) {
    }

    private static class TraceData {
        public final OutputBuffer buffer;
        public final int offset;

        public TraceData(OutputBuffer buffer, int offset) {
            this.buffer = buffer;
            this.offset = offset;
        }
    }
}

