/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class IfStatementExecutor
extends AbstractExecutor {
    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        Object condition;
        AST conditionAst = ast.getFirstChild();
        AST thenAst = conditionAst.getNextSibling();
        AST elseAst = null;
        context.getFrameStack().enterLocal(FrameType.UNPROTECTED, ast, new Variable[0]);
        if (ast.getNumberOfChildren() == 3) {
            elseAst = thenAst.getNextSibling();
        }
        if (!((condition = context.getExecutorFactory().executeAST(conditionAst, context)) instanceof Boolean)) {
            throw new EolIllegalReturnException("Boolean", condition, conditionAst, context);
        }
        Object result = null;
        if (((Boolean)condition).booleanValue()) {
            result = context.getExecutorFactory().executeAST(thenAst, context, true);
        } else if (elseAst != null) {
            result = context.getExecutorFactory().executeAST(elseAst, context, true);
        }
        context.getFrameStack().leaveLocal(ast);
        return result;
    }
}

