/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IUndefined;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.eol.types.EolType;

public class AnyOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return !(target instanceof EolNoType.EolNoTypeInstance);
    }

    public Object type() {
        if (EolPrimitiveType.String.isType(this.target)) {
            return EolPrimitiveType.String;
        }
        if (EolPrimitiveType.Boolean.isType(this.target)) {
            return EolPrimitiveType.Boolean;
        }
        if (EolPrimitiveType.Real.isType(this.target)) {
            return EolPrimitiveType.Real;
        }
        if (EolPrimitiveType.Integer.isType(this.target)) {
            return EolPrimitiveType.Integer;
        }
        if (EolCollectionType.Bag.isType(this.target)) {
            return EolCollectionType.Bag;
        }
        if (EolCollectionType.Sequence.isType(this.target)) {
            return EolCollectionType.Sequence;
        }
        if (EolCollectionType.Set.isType(this.target)) {
            return EolCollectionType.Set;
        }
        if (EolCollectionType.OrderedSet.isType(this.target)) {
            return EolCollectionType.OrderedSet;
        }
        IModel model = this.context.getModelRepository().getOwningModel(this.target);
        if (model != null) {
            return model.getTypeOf(this.target);
        }
        return null;
    }

    public String id() throws Exception {
        IModel model = this.context.getModelRepository().getOwningModel(this.target);
        if (model != null) {
            return model.getElementId(this.target);
        }
        throw new EolRuntimeException(String.valueOf(this.context.getPrettyPrinterManager().print(this.target)) + " is not a model element");
    }

    public boolean instanceOf(EolType type) {
        return this.isKindOf(type);
    }

    public boolean isTypeOf(EolType type) {
        return type.isType(this.target);
    }

    public boolean isKindOf(EolType type) {
        return type.isKind(this.target);
    }

    public Class<?> getNativeType() {
        return this.target.getClass();
    }

    public Class<?> nativeType() {
        return this.getNativeType();
    }

    public IModel getOwningModel() {
        return this.owningModel();
    }

    public IModel owningModel() {
        return this.context.getModelRepository().getOwningModel(this.target);
    }

    public boolean hasProperty(String property) throws Exception {
        IPropertyGetter getter = this.context.getIntrospectionManager().getPropertyGetterFor(this.target, property, this.context);
        try {
            getter.invoke(this.target, property);
        }
        catch (EolIllegalPropertyException pex) {
            return false;
        }
        return true;
    }

    public String asString() {
        return this.context.getPrettyPrinterManager().print(this.target);
    }

    public boolean isDefined() {
        if (this.target == null || this.target instanceof IUndefined) {
            return false;
        }
        return !(this.target instanceof String) || ((String)this.target).length() != 0;
    }

    public boolean isUndefined() {
        return !this.isDefined();
    }

    public Object ifUndefined(Object alternative) {
        if (this.isUndefined()) {
            return alternative;
        }
        return this.target;
    }

    public Object println() {
        return this.println("", "");
    }

    public Object println(Object prefix) {
        return this.println(prefix, "");
    }

    public Object println(Object prefix, Object suffix) {
        this.context.getOutputStream().println(prefix + this.context.getPrettyPrinterManager().print(this.target) + suffix);
        return this.target;
    }

    public Object print() {
        return this.print("", "");
    }

    public Object print(Object prefix) {
        return this.print(prefix, "");
    }

    public Object print(Object prefix, Object suffix) {
        this.context.getOutputStream().print(prefix + this.context.getPrettyPrinterManager().print(this.target) + suffix);
        return this.target;
    }

    public Object err() {
        return this.err("", "");
    }

    public Object err(Object prefix) {
        return this.err(prefix, "");
    }

    public Object err(Object prefix, Object suffix) {
        this.context.getErrorStream().print(prefix + this.context.getPrettyPrinterManager().print(this.target) + suffix);
        return this.target;
    }

    public Object errln() {
        return this.errln("", "");
    }

    public Object errln(Object prefix) {
        return this.errln(prefix, "");
    }

    public Object errln(Object prefix, Object suffix) {
        this.context.getErrorStream().println(prefix + this.context.getPrettyPrinterManager().print(this.target) + suffix);
        return this.target;
    }

    public String format(String formatString) {
        return String.format(formatString, this.target);
    }

    public int asInteger() {
        String value = this.target.toString();
        return Integer.parseInt(value);
    }

    public boolean isInteger() {
        String value = this.target.toString();
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isReal() {
        String value = this.target.toString();
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public float asReal() {
        String value = this.target.toString();
        return Float.parseFloat(value);
    }

    public double asDouble() {
        String value = this.target.toString();
        return Double.parseDouble(value);
    }

    public float asFloat() {
        String value = this.target.toString();
        return Float.parseFloat(value);
    }

    public long asLong() {
        String value = this.target.toString();
        return Long.parseLong(value);
    }

    public boolean asBoolean() {
        String value = this.target.toString();
        return Boolean.parseBoolean(value);
    }

    public String asUnicode() {
        String value = this.target.toString();
        return "" + (char)Integer.parseInt(value, 16);
    }
}

