/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.EolImport;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.erl.rules.INamedRule;
import org.eclipse.epsilon.etl.IEtlModule;
import org.eclipse.epsilon.etl.TransformRule;
import org.eclipse.epsilon.etl.TransformRules;
import org.eclipse.epsilon.etl.execute.EtlExecutorFactory;
import org.eclipse.epsilon.etl.execute.context.EtlContext;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;
import org.eclipse.epsilon.etl.execute.operations.EtlOperationFactory;
import org.eclipse.epsilon.etl.parse.EtlLexer;
import org.eclipse.epsilon.etl.parse.EtlParser;
import org.eclipse.epsilon.etl.strategy.DefaultTransformationStrategy;
import org.eclipse.epsilon.etl.strategy.FastTransformationStrategy;

public class EtlModule
extends ErlModule
implements IEtlModule {
    protected TransformRules declaredTransformRules = null;
    protected TransformRules transformRules = null;
    protected IEtlContext context = null;

    public EtlModule() {
        this.reset();
    }

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new EtlLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EtlParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "etlModule";
    }

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        for (AST matchRuleAst : AstUtil.getChildren(this.ast, 80)) {
            this.declaredTransformRules.add(new TransformRule(matchRuleAst));
        }
        this.getParseProblems().addAll(this.declaredTransformRules.calculateSuperRules(this.getTransformRules()));
    }

    @Override
    public TransformRules getDeclaredTransformRules() {
        return this.declaredTransformRules;
    }

    protected boolean hasLazyRules(IEtlContext context) {
        for (INamedRule rule : this.getTransformRules()) {
            TransformRule transformRule = (TransformRule)rule;
            try {
                if (!transformRule.isLazy()) continue;
                return true;
            }
            catch (EolRuntimeException eolRuntimeException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Object execute() throws EolRuntimeException {
        this.prepareContext(this.context);
        this.context.setOperationFactory(new EtlOperationFactory());
        EtlExecutorFactory etlExecutorFactory = new EtlExecutorFactory();
        etlExecutorFactory.setExecutionController(this.context.getExecutorFactory().getExecutionController());
        this.context.setExecutorFactory(etlExecutorFactory);
        if (this.hasLazyRules(this.context)) {
            this.context.setTransformationStrategy(new DefaultTransformationStrategy());
        } else {
            this.context.setTransformationStrategy(new FastTransformationStrategy());
        }
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("transTrace", this.context.getTransformationTrace()));
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("context", this.context));
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("module", this));
        this.execute(this.getPre(), this.context);
        if (this.context.getTransformationStrategy() != null) {
            this.context.getTransformationStrategy().transformModels(this.context);
        }
        this.execute(this.getPost(), this.context);
        return this.context.getTransformationTrace();
    }

    @Override
    public HashMap<String, Class<?>> getImportConfiguration() {
        HashMap<String, Class<?>> importConfiguration = super.getImportConfiguration();
        importConfiguration.put("etl", EtlModule.class);
        return importConfiguration;
    }

    @Override
    public IEtlContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(IEtlContext context) {
        this.context = context;
    }

    @Override
    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.getImports());
        children.addAll(this.getDeclaredPre());
        children.addAll(this.declaredTransformRules);
        children.addAll(this.getDeclaredPost());
        children.addAll(this.getDeclaredOperations());
        return children;
    }

    @Override
    public void reset() {
        super.reset();
        this.transformRules = null;
        this.declaredTransformRules = new TransformRules();
        this.context = new EtlContext();
    }

    @Override
    public TransformRules getTransformRules() {
        if (this.transformRules == null) {
            this.transformRules = new TransformRules();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEtlModule)) continue;
                IEtlModule module = (IEtlModule)import_.getModule();
                this.transformRules.addAll(module.getTransformRules());
            }
            this.transformRules.addAll(this.declaredTransformRules);
        }
        return this.transformRules;
    }

    @Override
    protected int getPostBlockTokenType() {
        return 77;
    }

    @Override
    protected int getPreBlockTokenType() {
        return 76;
    }

    @Override
    public void setContext(IEolContext context) {
        if (context instanceof IEtlContext) {
            this.context = (IEtlContext)context;
        }
    }
}

