/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.execution;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.flock.FlockExecution;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.execution.EolExecutor;
import org.eclipse.epsilon.flock.execution.GuardedConstructContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.common.ClassifierTypedConstruct;
import org.eclipse.epsilon.flock.model.domain.rules.Body;

public class MigrateRuleContext {
    private final Equivalence equivalence;
    private final EolExecutor executor;
    private final FlockExecution execution;
    private final Map<ClassifierTypedConstruct, Boolean> applicabilityCache = new HashMap<ClassifierTypedConstruct, Boolean>();

    public MigrateRuleContext(Equivalence equivalence, EolExecutor executor, FlockExecution execution) {
        this.equivalence = equivalence;
        this.executor = executor;
        this.execution = execution;
    }

    public boolean isEligibleFor(ClassifierTypedConstruct guardedConstruct) throws FlockRuntimeException {
        boolean applicability;
        if (this.applicabilityCache.containsKey(guardedConstruct)) {
            applicability = this.applicabilityCache.get(guardedConstruct);
        } else {
            applicability = guardedConstruct.appliesIn(this.getOriginal());
            this.applicabilityCache.put(guardedConstruct, applicability);
        }
        return applicability;
    }

    private GuardedConstructContext getOriginal() {
        return new GuardedConstructContext(this.equivalence.getOriginal(), this.executor);
    }

    public void execute(Body body) throws FlockRuntimeException {
        this.equivalence.ruleApplied(this.execution);
        body.applyTo(this.executor, this.equivalence.getVariables().toArray(new Variable[0]));
    }
}

