/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.flock.model.domain.rules.MigrateRule;

public class MigrateRuleBuilder {
    private final AST ast;
    private final String originalType;
    private AST body;
    private AST guard;
    private Collection<String> ignoredProperties = Collections.emptyList();
    private Collection<String> annotations = Collections.emptyList();

    public static MigrateRuleBuilder aMigrateRule(AST ast, String originalType) {
        return new MigrateRuleBuilder(ast, originalType);
    }

    public static MigrateRuleBuilder anUntraceableMigrateRule(String originalType) {
        return MigrateRuleBuilder.aMigrateRule(null, originalType);
    }

    private MigrateRuleBuilder(AST ast, String originalType) {
        this.ast = ast;
        this.originalType = originalType;
    }

    public MigrateRuleBuilder withGuard(AST guard) {
        this.guard = guard;
        return this;
    }

    public MigrateRuleBuilder withBody(AST body) {
        this.body = body;
        return this;
    }

    public MigrateRuleBuilder withIgnoredProperties(String ... properties) {
        return this.withIgnoredProperties(Arrays.asList(properties));
    }

    public MigrateRuleBuilder withIgnoredProperties(Collection<String> properties) {
        this.ignoredProperties = properties;
        return this;
    }

    public MigrateRuleBuilder withAnnotations(String ... annotations) {
        return this.withAnnotations(Arrays.asList(annotations));
    }

    public MigrateRuleBuilder withAnnotations(Collection<String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public MigrateRule build() {
        return new MigrateRule(this.ast, this.annotations, this.originalType, this.ignoredProperties, this.guard, this.body);
    }
}

